/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CountableThreadPool {
    private int threadNum;
    private AtomicInteger threadAlive = new AtomicInteger();
    private ReentrantLock reentrantLock = new ReentrantLock();
    private Condition condition = this.reentrantLock.newCondition();
    private ExecutorService executorService;

    public CountableThreadPool(int threadNum) {
        this.threadNum = threadNum;
        this.executorService = Executors.newFixedThreadPool(threadNum);
    }

    public CountableThreadPool(int threadNum, ExecutorService executorService) {
        this.threadNum = threadNum;
        this.executorService = executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public int getThreadAlive() {
        return this.threadAlive.get();
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable runnable) {
        if (this.threadAlive.get() >= this.threadNum) {
            try {
                this.reentrantLock.lock();
                while (this.threadAlive.get() >= this.threadNum) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        this.threadAlive.incrementAndGet();
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    try {
                        CountableThreadPool.this.reentrantLock.lock();
                        CountableThreadPool.this.threadAlive.decrementAndGet();
                        CountableThreadPool.this.condition.signal();
                    }
                    finally {
                        CountableThreadPool.this.reentrantLock.unlock();
                    }
                }
            }
        });
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

