/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.Scheduler;
import us.codecraft.webmagic.scheduler.component.DuplicateRemover;
import us.codecraft.webmagic.scheduler.component.HashSetDuplicateRemover;

public abstract class DuplicateRemovedScheduler
implements Scheduler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private DuplicateRemover duplicatedRemover = new HashSetDuplicateRemover();

    public DuplicateRemover getDuplicateRemover() {
        return this.duplicatedRemover;
    }

    public DuplicateRemovedScheduler setDuplicateRemover(DuplicateRemover duplicatedRemover) {
        this.duplicatedRemover = duplicatedRemover;
        return this;
    }

    @Override
    public void push(Request request, Task task) {
        this.logger.trace("get a candidate url {}", (Object)request.getUrl());
        if (!this.duplicatedRemover.isDuplicate(request, task) || this.shouldReserved(request)) {
            this.logger.debug("push to queue {}", (Object)request.getUrl());
            this.pushWhenNoDuplicate(request, task);
        }
    }

    protected boolean shouldReserved(Request request) {
        return request.getExtra("_cycle_tried_times") != null;
    }

    protected void pushWhenNoDuplicate(Request request, Task task) {
    }
}

