/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.CssSelector;
import us.codecraft.webmagic.selector.ElementSelector;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.Selectors;
import us.codecraft.webmagic.selector.SmartContentSelector;
import us.codecraft.webmagic.selector.XpathSelector;

public class Html
extends PlainText {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Document document;
    private boolean needInitCache = true;

    public Html(List<String> strings) {
        super(strings);
    }

    public Html(String text) {
        super(text);
    }

    public Html(List<String> strings, boolean needInitCache) {
        super(strings);
        this.needInitCache = needInitCache;
    }

    public Html(String text, boolean needInitCache) {
        super(text);
        this.needInitCache = needInitCache;
    }

    private void initDocument() {
        if (this.document == null && this.needInitCache) {
            this.needInitCache = false;
            try {
                this.document = Jsoup.parse((String)this.getText());
            }
            catch (Exception e) {
                this.logger.warn("parse document error ", (Throwable)e);
            }
        }
    }

    public Html(Document document) {
        super(document.html());
        this.document = document;
    }

    public static Html create(String text) {
        return new Html(text);
    }

    @Override
    protected Selectable select(Selector selector, List<String> strings) {
        this.initDocument();
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            String result = selector.select(string);
            if (result == null) continue;
            results.add(result);
        }
        return new Html(results, false);
    }

    @Override
    protected Selectable selectList(Selector selector, List<String> strings) {
        this.initDocument();
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            List<String> result = selector.selectList(string);
            results.addAll(result);
        }
        return new Html(results, false);
    }

    @Override
    public Selectable smartContent() {
        this.initDocument();
        SmartContentSelector smartContentSelector = Selectors.smartContent();
        return this.select(smartContentSelector, this.strings);
    }

    @Override
    public Selectable links() {
        return this.xpath("//a/@href");
    }

    @Override
    public Selectable xpath(String xpath) {
        XpathSelector xpathSelector = Selectors.xpath(xpath);
        if (this.document != null) {
            return new Html(xpathSelector.selectList((Element)this.document), false);
        }
        return this.selectList(xpathSelector, this.strings);
    }

    @Override
    public Selectable $(String selector) {
        CssSelector cssSelector = Selectors.$(selector);
        if (this.document != null) {
            return new Html(cssSelector.selectList((Element)this.document), false);
        }
        return this.selectList(cssSelector, this.strings);
    }

    @Override
    public Selectable $(String selector, String attrName) {
        CssSelector cssSelector = Selectors.$(selector, attrName);
        if (this.document != null) {
            return new Html(cssSelector.selectList((Element)this.document), false);
        }
        return this.selectList(cssSelector, this.strings);
    }

    public Document getDocument() {
        this.initDocument();
        return this.document;
    }

    public String getText() {
        if (this.strings != null && this.strings.size() > 0) {
            return (String)this.strings.get(0);
        }
        return this.document.html();
    }

    public String selectDocument(Selector selector) {
        if (selector instanceof ElementSelector) {
            ElementSelector elementSelector = (ElementSelector)((Object)selector);
            return elementSelector.select((Element)this.getDocument());
        }
        return selector.select(this.getText());
    }

    public List<String> selectDocumentForList(Selector selector) {
        if (selector instanceof ElementSelector) {
            ElementSelector elementSelector = (ElementSelector)((Object)selector);
            return elementSelector.selectList((Element)this.getDocument());
        }
        return selector.selectList(this.getText());
    }
}

