/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpHost;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.utils.UrlUtils;

public class Site {
    private String domain;
    private String userAgent;
    private Map<String, String> defaultCookies = new LinkedHashMap<String, String>();
    private Table<String, String, String> cookies = HashBasedTable.create();
    private String charset;
    private List<Request> startRequests = new ArrayList<Request>();
    private int sleepTime = 5000;
    private int retryTimes = 0;
    private int cycleRetryTimes = 0;
    private int timeOut = 5000;
    private static final Set<Integer> DEFAULT_STATUS_CODE_SET = new HashSet<Integer>();
    private Set<Integer> acceptStatCode = DEFAULT_STATUS_CODE_SET;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpHost httpProxy;
    private boolean useGzip = true;

    public static Site me() {
        return new Site();
    }

    public Site addCookie(String name, String value) {
        this.defaultCookies.put(name, value);
        return this;
    }

    public Site addCookie(String domain, String name, String value) {
        this.cookies.put((Object)domain, (Object)name, (Object)value);
        return this;
    }

    public Site setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public Map<String, String> getCookies() {
        return this.defaultCookies;
    }

    public Map<String, Map<String, String>> getAllCookies() {
        return this.cookies.rowMap();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDomain() {
        return this.domain;
    }

    public Site setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Site setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public Site setTimeOut(int timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public Site setAcceptStatCode(Set<Integer> acceptStatCode) {
        this.acceptStatCode = acceptStatCode;
        return this;
    }

    public Set<Integer> getAcceptStatCode() {
        return this.acceptStatCode;
    }

    @Deprecated
    public List<String> getStartUrls() {
        return UrlUtils.convertToUrls(this.startRequests);
    }

    public List<Request> getStartRequests() {
        return this.startRequests;
    }

    public Site addStartUrl(String startUrl) {
        return this.addStartRequest(new Request(startUrl));
    }

    public Site addStartRequest(Request startRequest) {
        this.startRequests.add(startRequest);
        if (this.domain == null && startRequest.getUrl() != null) {
            this.domain = UrlUtils.getDomain(startRequest.getUrl());
        }
        return this;
    }

    public Site setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Site addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Site setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public int getCycleRetryTimes() {
        return this.cycleRetryTimes;
    }

    public Site setCycleRetryTimes(int cycleRetryTimes) {
        this.cycleRetryTimes = cycleRetryTimes;
        return this;
    }

    public HttpHost getHttpProxy() {
        return this.httpProxy;
    }

    public Site setHttpProxy(HttpHost httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public Site setUseGzip(boolean useGzip) {
        this.useGzip = useGzip;
        return this;
    }

    public Task toTask() {
        return new Task(){

            @Override
            public String getUUID() {
                return Site.this.getDomain();
            }

            @Override
            public Site getSite() {
                return Site.this;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Site site = (Site)o;
        if (this.cycleRetryTimes != site.cycleRetryTimes) {
            return false;
        }
        if (this.retryTimes != site.retryTimes) {
            return false;
        }
        if (this.sleepTime != site.sleepTime) {
            return false;
        }
        if (this.timeOut != site.timeOut) {
            return false;
        }
        if (this.acceptStatCode != null ? !((Object)this.acceptStatCode).equals(site.acceptStatCode) : site.acceptStatCode != null) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(site.charset) : site.charset != null) {
            return false;
        }
        if (this.defaultCookies != null ? !((Object)this.defaultCookies).equals(site.defaultCookies) : site.defaultCookies != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(site.domain) : site.domain != null) {
            return false;
        }
        if (this.headers != null ? !((Object)this.headers).equals(site.headers) : site.headers != null) {
            return false;
        }
        if (this.startRequests != null ? !((Object)this.startRequests).equals(site.startRequests) : site.startRequests != null) {
            return false;
        }
        return !(this.userAgent != null ? !this.userAgent.equals(site.userAgent) : site.userAgent != null);
    }

    public int hashCode() {
        int result = this.domain != null ? this.domain.hashCode() : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.defaultCookies != null ? ((Object)this.defaultCookies).hashCode() : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + (this.startRequests != null ? ((Object)this.startRequests).hashCode() : 0);
        result = 31 * result + this.sleepTime;
        result = 31 * result + this.retryTimes;
        result = 31 * result + this.cycleRetryTimes;
        result = 31 * result + this.timeOut;
        result = 31 * result + (this.acceptStatCode != null ? ((Object)this.acceptStatCode).hashCode() : 0);
        result = 31 * result + (this.headers != null ? ((Object)this.headers).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Site{domain='" + this.domain + '\'' + ", userAgent='" + this.userAgent + '\'' + ", cookies=" + this.defaultCookies + ", charset='" + this.charset + '\'' + ", startRequests=" + this.startRequests + ", sleepTime=" + this.sleepTime + ", retryTimes=" + this.retryTimes + ", cycleRetryTimes=" + this.cycleRetryTimes + ", timeOut=" + this.timeOut + ", acceptStatCode=" + this.acceptStatCode + ", headers=" + this.headers + '}';
    }

    static {
        DEFAULT_STATUS_CODE_SET.add(200);
    }

    public static interface HeaderConst {
        public static final String REFERER = "Referer";
    }
}

