/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.selector.Html;

public abstract class AbstractDownloader
implements Downloader {
    public Html download(String url) {
        return this.download(url, null);
    }

    public Html download(String url, String charset) {
        Page page = this.download(new Request(url), Site.me().setCharset(charset).toTask());
        return page.getHtml();
    }

    protected Page addToCycleRetry(Request request, Site site) {
        Page page = new Page();
        Object cycleTriedTimesObject = request.getExtra("_cycle_tried_times");
        if (cycleTriedTimesObject == null) {
            page.addTargetRequest(request.setPriority(0L).putExtra("_cycle_tried_times", 1));
        } else {
            int cycleTriedTimes = (Integer)cycleTriedTimesObject;
            if (++cycleTriedTimes >= site.getCycleRetryTimes()) {
                return null;
            }
            page.addTargetRequest(request.setPriority(0L).putExtra("_cycle_tried_times", cycleTriedTimes));
        }
        page.setNeedCycleRetry(true);
        return page;
    }
}

