/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import us.codecraft.webmagic.selector.CssSelector;
import us.codecraft.webmagic.selector.ElementSelector;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.Selectors;
import us.codecraft.webmagic.selector.SmartContentSelector;
import us.codecraft.webmagic.selector.XpathSelector;
import us.codecraft.webmagic.selector.XsoupSelector;
import us.codecraft.webmagic.utils.EnvironmentUtil;

public class Html
extends PlainText {
    private Logger logger = Logger.getLogger(this.getClass());
    private Document document;

    public Html(List<String> strings) {
        super(strings);
    }

    public Html(String text) {
        super(text);
        try {
            this.document = Jsoup.parse((String)text);
        }
        catch (Exception e) {
            this.logger.warn((Object)"parse document error ", (Throwable)e);
        }
    }

    public Html(Document document) {
        super(document.html());
        this.document = document;
    }

    public static Html create(String text) {
        return new Html(text);
    }

    @Override
    protected Selectable select(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            String result = selector.select(string);
            if (result == null) continue;
            results.add(result);
        }
        return new Html(results);
    }

    @Override
    protected Selectable selectList(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            List<String> result = selector.selectList(string);
            results.addAll(result);
        }
        return new Html(results);
    }

    @Override
    public Selectable smartContent() {
        SmartContentSelector smartContentSelector = Selectors.smartContent();
        return this.select(smartContentSelector, this.strings);
    }

    @Override
    public Selectable links() {
        return this.xpath("//a/@href");
    }

    @Override
    public Selectable xpath(String xpath) {
        if (EnvironmentUtil.useXsoup()) {
            XsoupSelector xsoupSelector = new XsoupSelector(xpath);
            if (this.document != null) {
                return new Html(xsoupSelector.selectList((Element)this.document));
            }
            return this.selectList(xsoupSelector, this.strings);
        }
        XpathSelector xpathSelector = new XpathSelector(xpath);
        return this.selectList(xpathSelector, this.strings);
    }

    @Override
    public Selectable $(String selector) {
        CssSelector cssSelector = Selectors.$(selector);
        if (this.document != null) {
            return new Html(cssSelector.selectList((Element)this.document));
        }
        return this.selectList(cssSelector, this.strings);
    }

    @Override
    public Selectable $(String selector, String attrName) {
        CssSelector cssSelector = Selectors.$(selector, attrName);
        if (this.document != null) {
            return new Html(cssSelector.selectList((Element)this.document));
        }
        return this.selectList(cssSelector, this.strings);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getText() {
        if (this.strings != null && this.strings.size() > 0) {
            return (String)this.strings.get(0);
        }
        return this.document.html();
    }

    public String selectDocument(Selector selector) {
        if (selector instanceof ElementSelector) {
            ElementSelector elementSelector = (ElementSelector)((Object)selector);
            return elementSelector.select((Element)this.getDocument());
        }
        return selector.select(this.getText());
    }

    public List<String> selectDocumentForList(Selector selector) {
        if (selector instanceof ElementSelector) {
            ElementSelector elementSelector = (ElementSelector)((Object)selector);
            return elementSelector.selectList((Element)this.getDocument());
        }
        return selector.selectList(this.getText());
    }
}

