/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups.defaultthreadgroup;

import java.time.Duration;
import java.util.regex.Pattern;

public class Stage {
    private static final Pattern INT_PATTERN = Pattern.compile("^\\d+$");
    private final Object threadCount;
    private final Object duration;
    private final Object iterations;

    public Stage(Object threadCount, Object duration, Object iterations) {
        this.threadCount = this.tryParseInt(threadCount);
        this.duration = this.tryParseDuration(duration);
        this.iterations = this.tryParseInt(iterations);
    }

    public Object threadCount() {
        return this.threadCount;
    }

    public Object duration() {
        return this.duration;
    }

    public Object iterations() {
        return this.iterations;
    }

    private Object tryParseInt(Object val) {
        return val instanceof String && INT_PATTERN.matcher((String)val).matches() ? Integer.valueOf((String)val) : val;
    }

    private Object tryParseDuration(Object val) {
        Object ret = this.tryParseInt(val);
        return ret instanceof Integer ? Duration.ofSeconds(((Integer)ret).intValue()) : ret;
    }

    public boolean isFixedStage() {
        return !(!(this.threadCount instanceof Integer) || this.duration != null && !(this.duration instanceof Duration) || this.iterations != null && !(this.iterations instanceof Integer));
    }
}

