/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups;

import java.awt.Component;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.threads.UltimateThreadGroup;
import kg.apc.jmeter.threads.UltimateThreadGroupGui;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;
import us.abstracta.jmeter.javadsl.core.util.JmeterFunction;
import us.abstracta.jmeter.javadsl.core.util.SingleSeriesTimelinePanel;

public class DslDefaultThreadGroup
extends BaseThreadGroup<DslDefaultThreadGroup> {
    private static final Integer ZERO = 0;
    private final List<Stage> stages = new ArrayList<Stage>();

    public DslDefaultThreadGroup(String name, int threads, int iterations, List<BaseThreadGroup.ThreadGroupChild> children) {
        this(name, children);
        this.checkThreadCount(threads);
        if (iterations <= 0) {
            throw new IllegalArgumentException("Iterations must be >=1");
        }
        this.stages.add(new Stage(threads, Duration.ZERO, null));
        this.stages.add(new Stage(threads, null, iterations));
    }

    private DslDefaultThreadGroup(String name, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(name != null ? name : "Thread Group", (Class<? extends JMeterGUIComponent>)ThreadGroupGui.class, children);
    }

    public DslDefaultThreadGroup(String name, int threads, Duration duration, List<BaseThreadGroup.ThreadGroupChild> children) {
        this(name, children);
        this.checkThreadCount(threads);
        this.stages.add(new Stage(threads, Duration.ZERO, null));
        this.stages.add(new Stage(threads, duration, null));
    }

    public DslDefaultThreadGroup(String name) {
        this(name, Collections.emptyList());
    }

    private void checkThreadCount(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Threads count must be >=1");
        }
    }

    public DslDefaultThreadGroup rampTo(int threadCount, Duration duration) {
        if (threadCount < 0) {
            throw new IllegalArgumentException("Thread count must be >=0");
        }
        this.checkRampNotAfterIterations();
        this.addStage(new Stage(threadCount, duration, null));
        return this;
    }

    public DslDefaultThreadGroup rampTo(String threadCount, String duration) {
        this.checkRampNotAfterIterations();
        this.addStage(new Stage(threadCount, duration, null));
        return this;
    }

    private void checkRampNotAfterIterations() {
        if (this.isLastStageHoldingForIterations()) {
            throw new IllegalStateException("Ramping up/down after holding for iterations is not supported. If you used constructor with iterations, consider using threadGroup().rampTo(X, Y).holdForIterations(Z) instead");
        }
    }

    private boolean isLastStageHoldingForIterations() {
        return !this.stages.isEmpty() && this.getLastStage().duration == null;
    }

    private Stage getLastStage() {
        return this.stages.get(this.stages.size() - 1);
    }

    public void addStage(Stage stage) {
        this.stages.add(stage);
        if (!this.isSimpleThreadGroup() && this.stages.stream().anyMatch(s -> !s.isFixedStage())) {
            this.stages.remove(this.stages.size() - 1);
            throw new UnsupportedOperationException("The DSL does not yet support configuring multiple thread ramps with ramp or hold parameters using jmeter expressions. If you need this please create an issue in Github repository.");
        }
    }

    public DslDefaultThreadGroup holdFor(Duration duration) {
        this.checkHoldNotAfterIterations();
        this.addStage(new Stage(this.getPrevThreadsCount(), duration, null));
        return this;
    }

    public DslDefaultThreadGroup holdFor(String duration) {
        Object threadsCount = this.getPrevThreadsCount();
        this.checkHoldNotAfterIterations();
        this.addStage(new Stage(threadsCount, duration, null));
        return this;
    }

    private void checkHoldNotAfterIterations() {
        if (this.isLastStageHoldingForIterations()) {
            throw new IllegalStateException("Holding for duration after holding for iterations is not supported.");
        }
    }

    private Object getPrevThreadsCount() {
        return this.stages.isEmpty() ? Integer.valueOf(0) : this.getLastStage().threadCount;
    }

    public DslDefaultThreadGroup holdIterating(int iterations) {
        if (iterations < 0) {
            throw new IllegalArgumentException("Iterations must be >=0");
        }
        this.checkIterationsPreConditions();
        this.addStage(new Stage(this.getLastStage().threadCount, null, iterations));
        return this;
    }

    public DslDefaultThreadGroup holdIterating(String iterations) {
        this.checkIterationsPreConditions();
        this.addStage(new Stage(this.getLastStage().threadCount, null, iterations));
        return this;
    }

    private void checkIterationsPreConditions() {
        if (!(this.stages.size() == 1 && !ZERO.equals(this.stages.get(0).threadCount) || this.stages.size() == 2 && ZERO.equals(this.stages.get(0).threadCount) && !ZERO.equals(this.stages.get(1).threadCount))) {
            throw new IllegalStateException("Holding for iterations is only supported after initial hold and ramp, or ramp.");
        }
        if (ZERO.equals(this.getLastStage().threadCount)) {
            throw new IllegalStateException("Can't hold for iterations with no threads.");
        }
    }

    public DslDefaultThreadGroup rampToAndHold(int threads, Duration rampDuration, Duration holdDuration) {
        return this.rampTo(threads, rampDuration).holdFor(holdDuration);
    }

    public DslDefaultThreadGroup rampToAndHold(String threads, String rampDuration, String holdDuration) {
        return this.rampTo(threads, rampDuration).holdFor(holdDuration);
    }

    @Override
    public DslDefaultThreadGroup children(BaseThreadGroup.ThreadGroupChild ... children) {
        return (DslDefaultThreadGroup)super.children(children);
    }

    @Override
    public AbstractThreadGroup buildThreadGroup() {
        return this.isSimpleThreadGroup() ? this.buildSimpleThreadGroup() : this.buildUltimateThreadGroup();
    }

    private boolean isSimpleThreadGroup() {
        return this.stages.size() <= 1 || this.stages.size() == 2 && (ZERO.equals(this.stages.get(0).threadCount) || this.stages.get(0).threadCount.equals(this.stages.get(1).threadCount)) || this.stages.size() == 3 && ZERO.equals(this.stages.get(0).threadCount) && this.stages.get(1).threadCount.equals(this.stages.get(2).threadCount);
    }

    private AbstractThreadGroup buildSimpleThreadGroup() {
        Object threads = 1;
        Object iterations = 1;
        Object rampUpPeriod = null;
        Object duration = null;
        Object delay = null;
        if (!this.stages.isEmpty()) {
            Stage firstStage = this.stages.get(0);
            if (ZERO.equals(firstStage.threadCount)) {
                delay = firstStage.duration;
            } else {
                rampUpPeriod = firstStage.duration;
                threads = firstStage.threadCount;
            }
            iterations = firstStage.iterations;
            if (this.stages.size() > 1) {
                Stage secondStage = this.stages.get(1);
                threads = secondStage.threadCount;
                iterations = secondStage.iterations;
                if (ZERO.equals(firstStage.threadCount)) {
                    rampUpPeriod = secondStage.duration;
                    if (this.stages.size() > 2) {
                        Stage lastStage = this.stages.get(2);
                        duration = lastStage.duration;
                        iterations = lastStage.iterations;
                    }
                } else {
                    duration = secondStage.duration;
                }
            }
        }
        if (!(rampUpPeriod == null || Duration.ZERO.equals(rampUpPeriod) || iterations != null && duration == null)) {
            duration = duration != null ? this.sumDurations(duration, rampUpPeriod) : rampUpPeriod;
        }
        return this.buildSimpleThreadGroupFrom(threads, iterations, rampUpPeriod, duration, delay);
    }

    private Object sumDurations(Object duration, Object rampUpPeriod) {
        if (duration instanceof Duration && rampUpPeriod instanceof Duration) {
            return ((Duration)duration).plus((Duration)rampUpPeriod);
        }
        if (duration instanceof Duration) {
            duration = String.valueOf(DslDefaultThreadGroup.durationToSeconds((Duration)duration));
        } else if (rampUpPeriod instanceof Duration) {
            rampUpPeriod = String.valueOf(DslDefaultThreadGroup.durationToSeconds((Duration)rampUpPeriod));
        }
        return JmeterFunction.groovy(DslDefaultThreadGroup.buildGroovySolvingIntExpression((String)duration) + " + " + DslDefaultThreadGroup.buildGroovySolvingIntExpression((String)rampUpPeriod));
    }

    private static String buildGroovySolvingIntExpression(String expr) {
        return "(new org.apache.jmeter.engine.util.CompoundVariable('" + expr.replace("$", "#") + "'.replace('#','$')).execute() as int)";
    }

    private ThreadGroup buildSimpleThreadGroupFrom(Object threads, Object iterations, Object rampUpPeriod, Object duration, Object delay) {
        ThreadGroup ret = new ThreadGroup();
        this.setIntProperty((TestElement)ret, "ThreadGroup.num_threads", threads);
        this.setIntProperty((TestElement)ret, "ThreadGroup.ramp_time", rampUpPeriod == null ? Duration.ZERO : rampUpPeriod);
        LoopController loopController = new LoopController();
        ret.setSamplerController(loopController);
        if (duration != null) {
            loopController.setLoops(-1);
            this.setLongProperty((TestElement)ret, "ThreadGroup.duration", duration);
        } else {
            this.setIntProperty((TestElement)loopController, "LoopController.loops", iterations);
        }
        if (delay != null) {
            this.setLongProperty((TestElement)ret, "ThreadGroup.delay", delay);
        }
        if (duration != null || delay != null) {
            ret.setScheduler(true);
        }
        return ret;
    }

    private void setIntProperty(TestElement ret, String propName, Object value) {
        if (value instanceof Duration) {
            ret.setProperty(propName, (int)DslDefaultThreadGroup.durationToSeconds((Duration)value));
        } else if (value instanceof Integer) {
            ret.setProperty(propName, ((Integer)value).intValue());
        } else {
            ret.setProperty(propName, (String)value);
        }
    }

    private void setLongProperty(TestElement ret, String propName, Object value) {
        if (value instanceof Duration) {
            ret.setProperty(propName, DslDefaultThreadGroup.durationToSeconds((Duration)value));
        } else {
            ret.setProperty(propName, (String)value);
        }
    }

    private AbstractThreadGroup buildUltimateThreadGroup() {
        this.guiClass = UltimateThreadGroupGui.class;
        UltimateThreadGroup ret = new UltimateThreadGroup();
        PowerTableModel table = DslDefaultThreadGroup.buildUltimateThreadGroupTableModel();
        this.buildUltimateThreadGroupSchedules().forEach(s -> table.addRow(s.buildTableRow()));
        ret.setData(JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)table, (String)"ultimatethreadgroupdata"));
        LoopController loopController = new LoopController();
        loopController.setLoops(-1);
        loopController.setContinueForever(true);
        ret.setSamplerController(loopController);
        return ret;
    }

    private static PowerTableModel buildUltimateThreadGroupTableModel() {
        return new PowerTableModel(UltimateThreadGroupGui.columnIdentifiers, UltimateThreadGroupGui.columnClasses);
    }

    private List<UltimateThreadSchedule> buildUltimateThreadGroupSchedules() {
        ArrayList<UltimateThreadSchedule> ret = new ArrayList<UltimateThreadSchedule>();
        Duration delay = Duration.ZERO;
        int threads = 0;
        Stack<UltimateThreadSchedule> stack = new Stack<UltimateThreadSchedule>();
        UltimateThreadSchedule curr = new UltimateThreadSchedule(0, Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO);
        for (Stage s : this.stages) {
            int stageThreads = (Integer)s.threadCount;
            Duration stageDuration = (Duration)s.duration;
            if (stageThreads == threads) {
                curr.hold = curr.hold.plus(stageDuration);
            } else if (stageThreads > threads) {
                stack.add(curr);
                curr = new UltimateThreadSchedule(stageThreads - threads, delay, stageDuration, Duration.ZERO, Duration.ZERO);
            } else {
                int diff = threads - stageThreads;
                Duration shutdown = stageDuration;
                while (diff > curr.threadCount) {
                    curr.shutdown = DslDefaultThreadGroup.interpolateDurationForThreadCountWithRamp(curr.threadCount, diff, shutdown);
                    diff -= curr.threadCount;
                    shutdown = shutdown.minus(curr.shutdown);
                    curr = this.completeCurrentSchedule(curr, ret, stack);
                }
                if (diff == curr.threadCount) {
                    curr.shutdown = shutdown;
                } else {
                    Duration start = DslDefaultThreadGroup.interpolateDurationForThreadCountWithRamp(diff, curr.threadCount, curr.startup);
                    UltimateThreadSchedule last = curr;
                    curr = new UltimateThreadSchedule(diff, curr.delay.plus(curr.startup).minus(start), start, curr.hold, shutdown);
                    UltimateThreadSchedule ultimateThreadSchedule = last;
                    ultimateThreadSchedule.threadCount = ultimateThreadSchedule.threadCount - diff;
                    last.startup = last.startup.minus(start);
                    last.hold = Duration.ZERO;
                    stack.push(last);
                }
                curr = this.completeCurrentSchedule(curr, ret, stack);
            }
            threads = stageThreads;
            delay = delay.plus(stageDuration);
        }
        while (!stack.isEmpty()) {
            curr = this.completeCurrentSchedule(curr, ret, stack);
        }
        ret.sort(Comparator.comparing(r -> ((UltimateThreadSchedule)r).delay.toMillis()));
        return ret;
    }

    private static Duration interpolateDurationForThreadCountWithRamp(int threadCount, int rampThreads, Duration rampDuration) {
        return Duration.ofMillis((long)((double)rampDuration.toMillis() * ((double)threadCount / (double)rampThreads)));
    }

    private UltimateThreadSchedule completeCurrentSchedule(UltimateThreadSchedule curr, List<UltimateThreadSchedule> ret, Stack<UltimateThreadSchedule> stack) {
        ret.add(curr);
        UltimateThreadSchedule last = curr;
        curr = stack.pop();
        curr.hold = curr.hold.plus(last.startup).plus(last.hold).plus(last.shutdown);
        return curr;
    }

    @Deprecated
    public void showThreadsTimeline() {
        this.showTimeline();
    }

    public void showTimeline() {
        if (this.stages.stream().anyMatch(s -> !s.isFixedStage())) {
            throw new IllegalStateException("Can't display timeline when some JMeter expression is used in any ramp or hold.");
        }
        SingleSeriesTimelinePanel chart = new SingleSeriesTimelinePanel("Threads");
        chart.add(0L, 0.0);
        this.stages.forEach(s -> chart.add(((Duration)((Stage)s).duration).toMillis(), ((Integer)((Stage)s).threadCount).intValue()));
        this.showAndWaitFrameWith((Component)((Object)chart), this.name + " threads timeline", 800, 300);
    }

    private static class SampleErrorActionMethodParam
    extends MethodParam.FixedParam<BaseThreadGroup.SampleErrorAction> {
        private SampleErrorActionMethodParam(String expression, BaseThreadGroup.SampleErrorAction defaultValue) {
            super(BaseThreadGroup.SampleErrorAction.class, expression, BaseThreadGroup.SampleErrorAction::fromPropertyValue, defaultValue);
        }

        public static MethodParam from(TestElementParamBuilder paramBuilder) {
            return paramBuilder.buildParam("ThreadGroup.on_sample_error", SampleErrorActionMethodParam::new, BaseThreadGroup.SampleErrorAction.CONTINUE);
        }

        @Override
        public String buildCode(String indent) {
            return BaseThreadGroup.SampleErrorAction.class.getSimpleName() + "." + ((BaseThreadGroup.SampleErrorAction)((Object)this.value)).name();
        }
    }

    private static class ThreadsTimeline {
        private final Map<Duration, Integer> points = new LinkedHashMap<Duration, Integer>();
        private Duration lastDuration = Duration.ZERO;
        private int lastThreads;
        private double lastSlope;

        private ThreadsTimeline() {
        }

        private ThreadsTimeline(UltimateThreadSchedule s) {
            Duration duration = Duration.ZERO;
            if (!s.delay.isZero()) {
                duration = duration.plus(s.delay);
                this.points.put(duration, 0);
            }
            duration = duration.plus(s.startup);
            this.points.put(duration, s.threadCount);
            if (!s.hold.isZero()) {
                duration = duration.plus(s.hold);
                this.points.put(duration, s.threadCount);
            }
            duration = duration.plus(s.shutdown);
            this.points.put(duration, 0);
        }

        public static ThreadsTimeline fromSchedules(List<UltimateThreadSchedule> scheds) {
            ThreadsTimeline ret = new ThreadsTimeline();
            for (UltimateThreadSchedule s : scheds) {
                ret = ret.plus(new ThreadsTimeline(s));
            }
            return ret;
        }

        public ThreadsTimeline plus(ThreadsTimeline other) {
            Iterator<Map.Entry<Duration, Integer>> pendingIter;
            if (this.points.isEmpty()) {
                return other;
            }
            ThreadsTimeline ret = new ThreadsTimeline();
            Iterator<Map.Entry<Duration, Integer>> thisIter = this.points.entrySet().iterator();
            Iterator<Map.Entry<Duration, Integer>> otherIter = other.points.entrySet().iterator();
            Map.Entry<Duration, Integer> thisPoint = thisIter.next();
            Map.Entry<Duration, Integer> otherPoint = otherIter.next();
            int prevThisThread = 0;
            int prevOtherThread = 0;
            while (thisPoint != null && otherPoint != null) {
                int durationOrder = thisPoint.getKey().compareTo(otherPoint.getKey());
                if (durationOrder == 0) {
                    prevThisThread = thisPoint.getValue();
                    prevOtherThread = otherPoint.getValue();
                    ret.add(thisPoint.getKey(), prevThisThread + prevOtherThread);
                    thisPoint = this.nextPoint(thisIter);
                    otherPoint = this.nextPoint(otherIter);
                    continue;
                }
                if (durationOrder < 0) {
                    prevThisThread = thisPoint.getValue();
                    ret.add(thisPoint.getKey(), prevThisThread + prevOtherThread);
                    thisPoint = this.nextPoint(thisIter);
                    continue;
                }
                prevOtherThread = otherPoint.getValue();
                ret.add(otherPoint.getKey(), prevThisThread + prevOtherThread);
                otherPoint = this.nextPoint(otherIter);
            }
            Map.Entry<Duration, Integer> pendingPoint = thisPoint != null ? thisPoint : otherPoint;
            Iterator<Map.Entry<Duration, Integer>> iterator = pendingIter = thisPoint != null ? thisIter : otherIter;
            while (pendingPoint != null) {
                ret.add(pendingPoint.getKey(), pendingPoint.getValue());
                pendingPoint = this.nextPoint(pendingIter);
            }
            return ret;
        }

        private void add(Duration duration, int threads) {
            if (duration.equals(this.lastDuration) && threads == this.lastThreads) {
                return;
            }
            double slope = duration.equals(this.lastDuration) ? (threads > this.lastThreads ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : (double)(threads - this.lastThreads) / (double)duration.minus(this.lastDuration).getSeconds();
            if (Math.abs(slope - this.lastSlope) < 0.01) {
                this.points.remove(this.lastDuration);
            }
            this.points.put(duration, threads);
            this.lastDuration = duration;
            this.lastThreads = threads;
            this.lastSlope = slope;
        }

        private Map.Entry<Duration, Integer> nextPoint(Iterator<Map.Entry<Duration, Integer>> iter) {
            return iter.hasNext() ? iter.next() : null;
        }

        private MethodCall addMethodCallsTo(MethodCall methodCall) {
            int prevThreads = 0;
            Duration prevDuration = Duration.ZERO;
            Duration rampDuration = Duration.ZERO;
            Duration holdDuration = Duration.ZERO;
            for (Map.Entry<Duration, Integer> point : this.points.entrySet()) {
                if (point.getValue() == prevThreads) {
                    holdDuration = holdDuration.plus(point.getKey().minus(prevDuration));
                } else {
                    if (!rampDuration.isZero()) {
                        if (!holdDuration.isZero()) {
                            methodCall.chain("rampToAndHold", new MethodParam.IntParam(prevThreads), new MethodParam.DurationParam(rampDuration), new MethodParam.DurationParam(holdDuration));
                            holdDuration = Duration.ZERO;
                        } else {
                            this.chainRampTo(methodCall, prevThreads, rampDuration);
                        }
                    } else if (!holdDuration.isZero()) {
                        methodCall.chain("holdFor", new MethodParam.DurationParam(holdDuration));
                        holdDuration = Duration.ZERO;
                    }
                    rampDuration = point.getKey().minus(prevDuration);
                }
                prevThreads = point.getValue();
                prevDuration = point.getKey();
            }
            if (!rampDuration.isZero()) {
                this.chainRampTo(methodCall, prevThreads, rampDuration);
            }
            return methodCall;
        }

        private void chainRampTo(MethodCall methodCall, int threads, Duration rampDuration) {
            methodCall.chain("rampTo", new MethodParam.IntParam(threads), new MethodParam.DurationParam(rampDuration));
        }
    }

    public static class CodeBuilder
    extends MethodCallBuilder {
        public CodeBuilder(List<Method> builderMethods) {
            super(builderMethods);
        }

        @Override
        public boolean matches(MethodCallContext context) {
            TestElement testElement = context.getTestElement();
            return testElement.getClass() == ThreadGroup.class || testElement.getClass() == UltimateThreadGroup.class;
        }

        @Override
        protected MethodCall buildMethodCall(MethodCallContext context) {
            TestElement testElement = context.getTestElement();
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder(testElement);
            MethodCall ret = testElement.getClass() == ThreadGroup.class ? this.buildSimpleThreadGroupMethodCall(paramBuilder) : this.buildUltimateThreadGroupMethodCall(paramBuilder);
            ret.chain("sampleErrorAction", SampleErrorActionMethodParam.from(paramBuilder));
            return ret;
        }

        private MethodCall buildSimpleThreadGroupMethodCall(TestElementParamBuilder testElement) {
            MethodParam name = testElement.nameParam("Thread Group");
            MethodParam threads = testElement.intParam("ThreadGroup.num_threads");
            MethodParam rampTime = testElement.durationParam("ThreadGroup.ramp_time", Duration.ofSeconds(1L));
            MethodParam duration = testElement.durationParam("ThreadGroup.duration");
            MethodParam delay = testElement.durationParam("ThreadGroup.delay");
            MethodParam iterations = testElement.intParam("ThreadGroup.main_controller/LoopController.loops");
            if (threads instanceof MethodParam.IntParam && duration instanceof MethodParam.DurationParam && iterations instanceof MethodParam.IntParam && (rampTime.isDefault() || rampTime instanceof MethodParam.DurationParam && ((Duration)((MethodParam.DurationParam)rampTime).getValue()).isZero()) && delay.isDefault()) {
                return this.buildMethodCall(name, threads, duration.isDefault() ? iterations : duration, new MethodParam.ChildrenParam<BaseThreadGroup.ThreadGroupChild[]>(BaseThreadGroup.ThreadGroupChild[].class));
            }
            MethodCall ret = this.buildMethodCall(name);
            if (!delay.isDefault()) {
                ret.chain("holdFor", delay);
            }
            if (!duration.isDefault()) {
                ret.chain("rampToAndHold", threads, rampTime, this.buildDurationParam(duration, rampTime));
            } else {
                ret.chain("rampTo", threads, rampTime).chain("holdIterating", iterations);
            }
            return ret;
        }

        private MethodParam.DurationParam buildDurationParam(MethodParam duration, MethodParam rampTime) {
            if (duration instanceof MethodParam.DurationParam && rampTime instanceof MethodParam.DurationParam) {
                return new MethodParam.DurationParam(rampTime.isDefault() ? (Duration)((MethodParam.DurationParam)duration).getValue() : ((Duration)((MethodParam.DurationParam)duration).getValue()).minus((Duration)((MethodParam.DurationParam)rampTime).getValue()));
            }
            String expression = rampTime.isDefault() || rampTime instanceof MethodParam.DurationParam && ((Duration)((MethodParam.DurationParam)rampTime).getValue()).isZero() ? duration.getExpression() : JmeterFunction.groovy(DslDefaultThreadGroup.buildGroovySolvingIntExpression(duration.getExpression()) + " - " + DslDefaultThreadGroup.buildGroovySolvingIntExpression(rampTime.getExpression()));
            return new MethodParam.DurationParam(expression, null);
        }

        private MethodCall buildUltimateThreadGroupMethodCall(TestElementParamBuilder testElement) {
            MethodParam name = testElement.nameParam("jp@gc - Ultimate Thread Group");
            MethodCall ret = this.buildMethodCall(name);
            return ThreadsTimeline.fromSchedules(this.schedulesProp(testElement)).addMethodCallsTo(ret);
        }

        private List<UltimateThreadSchedule> schedulesProp(TestElementParamBuilder testElement) {
            JMeterProperty schedulesProp = testElement.prop("ultimatethreadgroupdata");
            PowerTableModel tableModel = DslDefaultThreadGroup.buildUltimateThreadGroupTableModel();
            JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)((CollectionProperty)schedulesProp), (PowerTableModel)tableModel);
            ArrayList<UltimateThreadSchedule> ret = new ArrayList<UltimateThreadSchedule>();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                ret.add(UltimateThreadSchedule.fromTableRow(tableModel.getRowData(i)));
            }
            return ret;
        }
    }

    protected static class UltimateThreadSchedule {
        private int threadCount;
        private final Duration delay;
        private Duration startup;
        private Duration hold;
        private Duration shutdown;

        public UltimateThreadSchedule(int threadCount, Duration delay, Duration startup, Duration hold, Duration shutdown) {
            this.threadCount = threadCount;
            this.delay = delay;
            this.startup = startup;
            this.hold = hold;
            this.shutdown = shutdown;
        }

        public static UltimateThreadSchedule fromTableRow(Object[] row) {
            int i = 0;
            return new UltimateThreadSchedule(Integer.parseInt(UltimateThreadSchedule.stringProp(row[i++])), UltimateThreadSchedule.duration(row[i++]), UltimateThreadSchedule.duration(row[i++]), UltimateThreadSchedule.duration(row[i++]), UltimateThreadSchedule.duration(row[i]));
        }

        private static Duration duration(Object val) {
            return Duration.ofSeconds(Long.parseLong(UltimateThreadSchedule.stringProp(val)));
        }

        private static String stringProp(Object val) {
            return ((JMeterProperty)val).getStringValue();
        }

        public Object[] buildTableRow() {
            return new Object[]{String.valueOf(this.threadCount), String.valueOf(DslDefaultThreadGroup.durationToSeconds(this.delay)), String.valueOf(DslDefaultThreadGroup.durationToSeconds(this.startup)), String.valueOf(DslDefaultThreadGroup.durationToSeconds(this.hold)), String.valueOf(DslDefaultThreadGroup.durationToSeconds(this.shutdown))};
        }
    }

    private static class Stage {
        private static final Pattern INT_PATTERN = Pattern.compile("^\\d+$");
        private final Object threadCount;
        private final Object duration;
        private final Object iterations;

        private Stage(Object threadCount, Object duration, Object iterations) {
            this.threadCount = this.tryParseInt(threadCount);
            this.duration = this.tryParseDuration(duration);
            this.iterations = this.tryParseInt(iterations);
        }

        private Object tryParseInt(Object val) {
            return val instanceof String && INT_PATTERN.matcher((String)val).matches() ? Integer.valueOf((String)val) : val;
        }

        private Object tryParseDuration(Object val) {
            Object ret = this.tryParseInt(val);
            return ret instanceof Integer ? Duration.ofSeconds(((Integer)ret).intValue()) : ret;
        }

        public boolean isFixedStage() {
            return !(!(this.threadCount instanceof Integer) || this.duration != null && !(this.duration instanceof Duration) || this.iterations != null && !(this.iterations instanceof Integer));
        }
    }
}

