/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.samplers;

import java.time.Duration;
import kg.apc.jmeter.dummy.DummyElement;
import kg.apc.jmeter.samplers.DummySampler;
import kg.apc.jmeter.samplers.DummySamplerGui;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.samplers.BaseSampler;
import us.abstracta.jmeter.javadsl.core.util.JmeterFunction;

public class DslDummySampler
extends BaseSampler<DslDummySampler> {
    private final String responseBody;
    private boolean successful = true;
    private String responseCode = "200";
    private String responseMessage = "OK";
    private String responseTime = JmeterFunction.from("__Random", 50, 500);
    private boolean simulateResponseTime;
    private String url = "";
    private String requestBody = "";

    public DslDummySampler(String name, String responseBody) {
        super(name == null ? "jp@gc - Dummy Sampler" : name, DummySamplerGui.class);
        this.responseBody = responseBody;
    }

    public DslDummySampler successful(boolean successful) {
        this.successful = successful;
        return this;
    }

    public DslDummySampler responseCode(String code) {
        this.responseCode = code;
        return this;
    }

    public DslDummySampler responseMessage(String message) {
        this.responseMessage = message;
        return this;
    }

    public DslDummySampler responseTime(Duration responseTime) {
        this.responseTime = String.valueOf(responseTime.toMillis());
        return this;
    }

    public DslDummySampler simulateResponseTime(boolean simulate) {
        this.simulateResponseTime = simulate;
        return this;
    }

    public DslDummySampler url(String url) {
        this.url = url;
        return this;
    }

    public DslDummySampler requestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        DummySampler ret = new DummySampler();
        DummyElement dummy = ret.getDummy();
        dummy.setResponseData(this.responseBody);
        dummy.setSuccessful(this.successful);
        dummy.setResponseCode(this.responseCode);
        dummy.setResponseMessage(this.responseMessage);
        dummy.setResponseTime(this.responseTime);
        dummy.setSimulateWaiting(this.simulateResponseTime);
        dummy.setURL(this.url);
        dummy.setRequestData(this.requestBody);
        return ret;
    }
}

