/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.core.assertions.DslAssertion;
import us.abstracta.jmeter.javadsl.core.configs.DslConfig;
import us.abstracta.jmeter.javadsl.core.configs.DslVariables;
import us.abstracta.jmeter.javadsl.core.controllers.DslController;
import us.abstracta.jmeter.javadsl.core.listeners.DslListener;
import us.abstracta.jmeter.javadsl.core.postprocessors.DslPostProcessor;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslPreProcessor;
import us.abstracta.jmeter.javadsl.core.samplers.DslSampler;
import us.abstracta.jmeter.javadsl.core.threadgroups.DslThreadGroup;
import us.abstracta.jmeter.javadsl.core.timers.DslTimer;

public abstract class MethodParam {
    protected final Class<?> paramType;
    protected final String expression;

    protected MethodParam(Class<?> paramType, String expression) {
        this.paramType = paramType;
        this.expression = expression != null && expression.isEmpty() ? null : expression;
    }

    public String getExpression() {
        return this.expression == null ? "" : this.expression;
    }

    protected Class<?> getType() {
        return this.paramType;
    }

    public boolean isDefault() {
        return this.expression == null;
    }

    protected boolean isIgnored() {
        return false;
    }

    protected String buildCode(String indent) {
        return MethodParam.buildStringLiteral(this.getExpression());
    }

    protected static String buildStringLiteral(String value) {
        return "\"" + value.replaceAll("[\\\\\"\n\t\r]", "\\\\$0") + "\"";
    }

    protected static <T> Map<T, String> findConstantNames(Class<?> constantsHolderClass, Class<T> constantClass, Predicate<Field> filter) {
        return Arrays.stream(constantsHolderClass.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && f.getType() == constantClass && filter.test((Field)f)).collect(Collectors.toMap(f -> {
            try {
                return constantClass.cast(f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, Field::getName));
    }

    public static class ChildrenParam<T>
    extends MethodParam {
        private static final Class<?>[][] EXECUTION_ORDERS = new Class[][]{{DslVariables.class}, {DslConfig.class}, {DslPreProcessor.class}, {DslTimer.class}, {DslThreadGroup.class, DslController.class, DslSampler.class}, {DslPostProcessor.class}, {DslAssertion.class}, {DslListener.class}};
        private final List<MethodCall> children = new ArrayList<MethodCall>();

        public ChildrenParam(Class<T> childrenClass) {
            super(ChildrenParam.checkChildrenType(childrenClass), null);
        }

        private static <T> Class<T> checkChildrenType(Class<T> childrenClass) {
            if (!childrenClass.isArray()) {
                throw new IllegalArgumentException("You need always to provide an array class and not the raw class for the children. Eg use TestPlanChild[].class");
            }
            return childrenClass;
        }

        @Override
        public String buildCode(String indent) {
            List childrenCalls = this.children.stream().sorted(Comparator.comparing(c -> ChildrenParam.findExecutionOrder(c.getReturnType()))).collect(Collectors.toList());
            String ret = childrenCalls.stream().map(c -> c.buildCode(indent)).filter(s -> !s.isEmpty()).collect(Collectors.joining(",\n" + indent));
            return ret.isEmpty() ? ret : "\n" + indent + ret + "\n";
        }

        private static int findExecutionOrder(Class<?> returnType) {
            for (int i = 0; i < EXECUTION_ORDERS.length; ++i) {
                if (!Arrays.stream(EXECUTION_ORDERS[i]).anyMatch(c -> c.isAssignableFrom(returnType))) continue;
                return i;
            }
            return -1;
        }

        public void addChild(MethodCall child) {
            Class<?> childrenType = this.paramType.getComponentType();
            if (!childrenType.isAssignableFrom(child.getReturnType())) {
                throw new IllegalArgumentException("Trying to add a child of type " + child.getReturnType() + " that is not compatible with the declared ones : " + childrenType);
            }
            this.children.add(child);
        }
    }

    public static class DurationParam
    extends FixedParam<Duration> {
        public DurationParam(String expression, Duration defaultValue) {
            super(Duration.class, expression, v -> Duration.ofSeconds(Long.parseLong(v)), defaultValue);
        }

        public DurationParam(Duration value) {
            super(Duration.class, value, null);
        }

        @Override
        public String buildCode(String indent) {
            return ((Duration)this.value).isZero() ? Duration.class.getSimpleName() + ".ZERO" : MethodCall.forStaticMethod(Duration.class, "ofSeconds", new LongParam(((Duration)this.value).getSeconds())).buildCode();
        }
    }

    public static class BoolParam
    extends FixedParam<Boolean> {
        public BoolParam(String expression, Boolean defaultValue) {
            super(Boolean.TYPE, expression != null && expression.isEmpty() ? Boolean.FALSE.toString() : expression, BoolParam::parseBool, defaultValue);
        }

        public BoolParam(Boolean value, Boolean defaultValue) {
            super(Boolean.TYPE, value, defaultValue);
        }

        private static Boolean parseBool(String value) {
            if (!String.valueOf(true).equals(value) && !String.valueOf(false).equals(value)) {
                throw new IllegalArgumentException();
            }
            return Boolean.valueOf(value);
        }
    }

    public static class LongParam
    extends FixedParam<Long> {
        public LongParam(long seconds) {
            super(Long.TYPE, seconds, null);
        }
    }

    public static class IntParam
    extends FixedParam<Integer> {
        public IntParam(String expression, Integer defaultValue) {
            super(Integer.TYPE, expression, Integer::valueOf, defaultValue);
        }

        public IntParam(int value) {
            super(Integer.TYPE, value, null);
        }
    }

    public static abstract class FixedParam<T>
    extends MethodParam {
        protected final T value;
        protected final T defaultValue;

        protected FixedParam(Class<T> paramType, String expression, Function<String, T> parser, T defaultValue) {
            super(paramType, expression);
            this.value = this.expression != null ? parser.apply(expression) : null;
            this.defaultValue = defaultValue;
        }

        protected FixedParam(Class<T> paramType, T value, T defaultValue) {
            super(paramType, value == null ? null : value.toString());
            this.value = value;
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean isDefault() {
            return super.isDefault() || this.defaultValue != null && this.defaultValue.equals(this.value);
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public String buildCode(String indent) {
            return String.valueOf(this.value);
        }
    }

    public static class DynamicParam
    extends MethodParam {
        private static final Pattern DYNAMIC_VALUE_PATTERN = Pattern.compile(".*\\$\\{.+}.*");

        protected DynamicParam(String expression) {
            super(String.class, expression);
        }

        public static boolean matches(String propVal) {
            return DYNAMIC_VALUE_PATTERN.matcher(propVal).matches();
        }
    }

    public static class StringParam
    extends FixedParam<String> {
        public StringParam(String expression, String defaultValue) {
            super(String.class, expression, v -> v, defaultValue);
        }

        public StringParam(String value) {
            this(value, null);
        }

        @Override
        public String buildCode(String indent) {
            return StringParam.buildStringLiteral((String)this.value);
        }
    }

    public static class NameParam
    extends StringParam {
        public NameParam(String name, String defaultName) {
            super(name, defaultName);
        }

        @Override
        public boolean isIgnored() {
            return this.isDefault();
        }
    }
}

