/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;

public abstract class AutoEnabledHttpConfigElement
extends BaseConfigElement {
    protected boolean enabled = true;

    protected AutoEnabledHttpConfigElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        super(name, guiClass);
    }

    public void registerDependency(BuildTreeContext context) {
        this.registerEndListener(context, this.getOrCreateContextEntry(context));
    }

    public BuildContextEntry getOrCreateContextEntry(BuildTreeContext context) {
        return context.getOrCreateEntry(this.getClass().getSimpleName(), () -> new BuildContextEntry());
    }

    private void registerEndListener(BuildTreeContext context, BuildContextEntry entry) {
        if (!entry.registeredListener) {
            entry.registeredListener = true;
            context.addEndListener(this.buildEndListener());
        }
    }

    public BuildTreeContext.TreeContextEndListener buildEndListener() {
        return (context, tree) -> {
            BuildTreeContext parent = context.getParent();
            BuildContextEntry entry = this.getOrCreateContextEntry(context);
            if (parent == null) {
                this.endRootElement(context, tree, entry);
            } else if (entry.enabled == null) {
                this.endUnsolvedElement(context, tree, entry, parent);
            } else if (entry.enabled.booleanValue()) {
                this.endEnabledElement(context, tree, entry);
            } else {
                this.endDisabledElement(parent);
            }
        };
    }

    private void endRootElement(BuildTreeContext context, HashTree tree, BuildContextEntry contextEntry) {
        if (contextEntry.hasDisabledChild) {
            this.addConfigToPendingResolutionChildren(contextEntry);
        } else if (contextEntry.enabled == null || contextEntry.enabled.booleanValue()) {
            super.buildTreeUnder(tree, context);
        }
    }

    private void addConfigToPendingResolutionChildren(BuildContextEntry contextEntry) {
        contextEntry.pendingResolution.forEach((x$0, x$1) -> super.buildTreeUnder((HashTree)x$0, (BuildTreeContext)x$1));
    }

    private void endUnsolvedElement(BuildTreeContext context, HashTree tree, BuildContextEntry entry, BuildTreeContext parent) {
        BuildContextEntry parentEntry = this.getOrCreateContextEntry(parent);
        if (entry.hasDisabledChild) {
            this.addConfigToPendingResolutionChildren(entry);
            parentEntry.hasDisabledChild = true;
        } else {
            parentEntry.pendingResolution.put(tree, context);
        }
        this.registerEndListener(parent, parentEntry);
    }

    private void endEnabledElement(BuildTreeContext context, HashTree tree, BuildContextEntry entry) {
        if (entry.hasDisabledChild) {
            this.addConfigToPendingResolutionChildren(entry);
        } else {
            super.buildTreeUnder(tree, context);
        }
    }

    private void endDisabledElement(BuildTreeContext parent) {
        BuildContextEntry parentEntry = this.getOrCreateContextEntry(parent);
        parentEntry.hasDisabledChild = true;
        this.registerEndListener(parent, parentEntry);
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        BuildTreeContext parentContext = context.getParent();
        BuildContextEntry entry = this.getOrCreateContextEntry(parentContext);
        entry.enabled = this.enabled;
        this.registerEndListener(parentContext, entry);
        return parent;
    }

    public static abstract class CodeBuilder<T extends TestElement>
    extends SingleTestElementCallBuilder<T> {
        public CodeBuilder(Class<T> testElementClass, List<Method> builderMethods) {
            super(testElementClass, builderMethods);
        }

        public void registerDependency(MethodCallContext context, MethodCall call) {
            if (!this.findConfigElementInSamplerScope(context)) {
                this.registerPendingDisableConfig(context, call);
            }
        }

        private boolean findConfigElementInSamplerScope(MethodCallContext samplerContext) {
            MethodCallContext parent = samplerContext.getParent();
            return samplerContext.getChildrenTree().list().stream().anyMatch(this.testElementClass::isInstance) || parent != null && this.findConfigElementInSamplerScope(parent);
        }

        private void registerPendingDisableConfig(MethodCallContext context, MethodCall call) {
            MethodCallContext parentContext = context.getParent();
            if (parentContext == null) {
                this.addDisabledChild(call);
                return;
            }
            CallContextEntry parentEntry = this.getOrCreateContextEntry(parentContext);
            parentEntry.pendingDisableConfigs.add(call);
            if (parentEntry.endListenerRegistered) {
                return;
            }
            parentEntry.endListenerRegistered = true;
            parentContext.addEndListener((ctx, listenerCall) -> {
                if (parentEntry.hasChildWithConfig) {
                    parentEntry.pendingDisableConfigs.forEach(this::addDisabledChild);
                } else {
                    this.registerPendingDisableConfig(ctx, listenerCall);
                }
            });
        }

        private void addDisabledChild(MethodCall call) {
            call.child(this.buildMethodCall(new MethodParam[0]).chain("disable", new MethodParam[0]));
        }

        private CallContextEntry getOrCreateContextEntry(MethodCallContext context) {
            CallContextEntry ctx = (CallContextEntry)context.getEntry(this.getClass());
            if (ctx == null) {
                ctx = new CallContextEntry();
                context.setEntry(this.getClass(), ctx);
            }
            return ctx;
        }

        @Override
        protected MethodCall buildMethodCall(T testElement, MethodCallContext context) {
            if (this.findSamplerInConfigScope(context)) {
                for (MethodCallContext parent = context.getParent(); parent != null; parent = parent.getParent()) {
                    this.getOrCreateContextEntry(parent).hasChildWithConfig = true;
                }
                return MethodCall.emptyCall();
            }
            return this.buildMethodCall(new MethodParam[0]);
        }

        private boolean findSamplerInConfigScope(MethodCallContext context) {
            MethodCallContext parent = context.getParent();
            return parent.getTestElement() instanceof HTTPSamplerProxy || this.findSamplerInTree(parent.getChildrenTree());
        }

        private boolean findSamplerInTree(HashTree tree) {
            return tree != null && tree.list().stream().anyMatch(c -> c instanceof HTTPSamplerProxy || this.findSamplerInTree(tree.getTree(c)));
        }

        private static class CallContextEntry {
            private final List<MethodCall> pendingDisableConfigs = new ArrayList<MethodCall>();
            private boolean endListenerRegistered;
            private boolean hasChildWithConfig;

            private CallContextEntry() {
            }
        }
    }

    private static class BuildContextEntry {
        private Boolean enabled;
        private boolean registeredListener;
        private final Map<HashTree, BuildTreeContext> pendingResolution = new LinkedHashMap<HashTree, BuildTreeContext>();
        private boolean hasDisabledChild;

        private BuildContextEntry() {
        }
    }
}

