/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.configs;

import com.blazemeter.jmeter.RandomCSVDataSetConfig;
import com.blazemeter.jmeter.RandomCSVDataSetConfigGui;
import java.nio.charset.StandardCharsets;
import org.apache.jmeter.config.CSVDataSet;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;

public class DslCsvDataSet
extends BaseConfigElement {
    private final String file;
    private String delimiter = ",";
    private String encoding = StandardCharsets.UTF_8.name();
    private String[] variableNames;
    private boolean ignoreFirstLine;
    private boolean stopThread;
    private Sharing shareMode = Sharing.ALL_THREADS;
    private boolean randomOrder;

    public DslCsvDataSet(String csvFile) {
        super("CSV Data Set Config", TestBeanGUI.class);
        this.file = csvFile;
    }

    public DslCsvDataSet delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public DslCsvDataSet encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslCsvDataSet variableNames(String ... variableNames) {
        this.variableNames = variableNames;
        return this;
    }

    public DslCsvDataSet ignoreFirstLine() {
        this.ignoreFirstLine = true;
        return this;
    }

    public DslCsvDataSet stopThreadOnEOF() {
        this.stopThread = true;
        return this;
    }

    public DslCsvDataSet sharedIn(Sharing shareMode) {
        this.shareMode = shareMode;
        return this;
    }

    public DslCsvDataSet randomOrder() {
        this.randomOrder = true;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        return this.randomOrder ? this.buildRandomCsvDataSet() : this.buildSimpleCsvDataSet();
    }

    private TestElement buildRandomCsvDataSet() {
        this.guiClass = RandomCSVDataSetConfigGui.class;
        RandomCSVDataSetConfig ret = new RandomCSVDataSetConfig();
        ret.setFilename(this.file);
        ret.setDelimiter(this.delimiter);
        ret.setFileEncoding(this.encoding);
        if (this.variableNames != null) {
            ret.setVariableNames(this.buildVariablesPropertyValue());
        }
        ret.setIgnoreFirstLine(this.ignoreFirstLine);
        if (this.shareMode == Sharing.THREAD_GROUP) {
            throw new IllegalStateException("CSV data sets with random order, don't support THREAD_GROUP sharing mode");
        }
        ret.setIndependentListPerThread(this.shareMode == Sharing.THREAD);
        ret.setRewindOnTheEndOfList(!this.stopThread);
        ret.setRandomOrder(this.randomOrder);
        return ret;
    }

    private String buildVariablesPropertyValue() {
        return String.join((CharSequence)",", this.variableNames);
    }

    private CSVDataSet buildSimpleCsvDataSet() {
        CSVDataSet ret = new CSVDataSet();
        ret.setFilename(this.file);
        ret.setDelimiter(this.delimiter);
        ret.setFileEncoding(this.encoding);
        if (this.variableNames != null) {
            ret.setVariableNames(this.buildVariablesPropertyValue());
        }
        ret.setIgnoreFirstLine(this.ignoreFirstLine);
        ret.setQuotedData(true);
        ret.setRecycle(!this.stopThread);
        ret.setStopThread(this.stopThread);
        ret.setShareMode(this.shareMode.jmeterPropertyValue);
        return ret;
    }

    public static enum Sharing {
        ALL_THREADS("all"),
        THREAD_GROUP("group"),
        THREAD("thread");

        private final String jmeterPropertyValue;

        private Sharing(String jmeterPropertySuffix) {
            this.jmeterPropertyValue = "shareMode." + jmeterPropertySuffix;
        }
    }
}

