/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import us.abstracta.jmeter.javadsl.core.AggregatingTestPlanStats;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;

public class EmbeddedJmeterEngine
implements DslJmeterEngine {
    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();){
            StandardJMeterEngine engine = new StandardJMeterEngine();
            HashTree rootTree = new HashTree();
            HashTree testPlanTree = testPlan.buildTreeUnder(rootTree);
            AggregatingTestPlanStats stats = new AggregatingTestPlanStats();
            this.addTestStatsCollectorToTree(stats, testPlanTree);
            this.addTestSummariserToTree(testPlanTree);
            engine.configure(rootTree);
            engine.run();
            AggregatingTestPlanStats aggregatingTestPlanStats = stats;
            return aggregatingTestPlanStats;
        }
    }

    private void addTestStatsCollectorToTree(final AggregatingTestPlanStats stats, HashTree tree) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        tree.add((Object)collector);
        tree.add((Object)statsVisualizer);
    }

    private void addTestSummariserToTree(HashTree tree) {
        tree.add((Object)new ResultCollector(new Summariser()));
    }

    public static void saveTestPlanToJmx(DslTestPlan dslTestPlan, String filePath) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();
             FileOutputStream output = new FileOutputStream(filePath);){
            ListedHashTree tree = new ListedHashTree();
            dslTestPlan.buildTreeUnder((HashTree)tree);
            SaveService.saveTree((HashTree)tree, (OutputStream)output);
        }
    }

    public static DslTestPlan loadTestPlanFromJmx(String filePath) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();){
            HashTree tree = SaveService.loadTree((File)new File(filePath));
            DslTestPlan dslTestPlan = DslTestPlan.fromTree(tree);
            return dslTestPlan;
        }
    }

    private static class JMeterEnvironment
    implements Closeable {
        private final File propsDir = Files.createTempDirectory("jmeter-java-dsl", new FileAttribute[0]).toFile();

        private JMeterEnvironment() throws IOException {
            try {
                this.setupJMeterProperties(this.propsDir);
            }
            catch (IOException | RuntimeException e) {
                FileUtils.deleteDirectory((File)this.propsDir);
                throw e;
            }
        }

        private void setupJMeterProperties(File propsDir) throws IOException {
            File propsFile = new File(propsDir, "jmeter.properties");
            propsFile.createNewFile();
            JMeterUtils.loadJMeterProperties((String)propsFile.toString());
            JMeterUtils.setProperty((String)"search_paths", (String)this.getFunctionsJarPath());
            JMeterUtils.setProperty((String)"saveservice_properties", (String)this.installPropertiesFile(propsDir, "saveservice.properties"));
            JMeterUtils.setProperty((String)"upgrade_properties", (String)this.installPropertiesFile(propsDir, "upgrade.properties"));
        }

        private String getFunctionsJarPath() {
            try {
                return new File(EvalFunction.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private String installPropertiesFile(File propsDir, String propsFileName) throws IOException {
            Path saveServicePropsPath = propsDir.toPath().resolve(propsFileName);
            Files.copy(this.getClass().getResourceAsStream("/bin/" + propsFileName), saveServicePropsPath, new CopyOption[0]);
            return saveServicePropsPath.toString();
        }

        @Override
        public void close() throws IOException {
            FileUtils.deleteDirectory((File)this.propsDir);
        }
    }
}

