/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import org.apache.jmeter.extractor.BoundaryExtractor;
import org.apache.jmeter.extractor.gui.BoundaryExtractorGui;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.postprocessors.DslVariableExtractor;

public class DslBoundaryExtractor
extends DslVariableExtractor<DslBoundaryExtractor> {
    private final String leftBoundary;
    private final String rightBoundary;
    private TargetField fieldToCheck = TargetField.RESPONSE_BODY;

    public DslBoundaryExtractor(String varName, String leftBoundary, String rightBoundary) {
        super("Boundary Extractor", BoundaryExtractorGui.class, varName);
        this.leftBoundary = leftBoundary;
        this.rightBoundary = rightBoundary;
    }

    public DslBoundaryExtractor matchNumber(int matchNumber) {
        this.matchNumber = matchNumber;
        return this;
    }

    public DslBoundaryExtractor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DslBoundaryExtractor fieldToCheck(TargetField fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        BoundaryExtractor ret = new BoundaryExtractor();
        this.setScopeTo((AbstractScopedTestElement)ret);
        ret.setUseField(this.fieldToCheck.propertyValue);
        ret.setRefName(this.varName);
        ret.setLeftBoundary(this.leftBoundary);
        ret.setRightBoundary(this.rightBoundary);
        ret.setMatchNumber(this.matchNumber);
        if (this.defaultValue != null) {
            if (this.defaultValue.isEmpty()) {
                ret.setDefaultEmptyValue(true);
            } else {
                ret.setDefaultValue(this.defaultValue);
            }
        }
        return ret;
    }

    public static enum TargetField {
        RESPONSE_BODY("false"),
        RESPONSE_BODY_UNESCAPED("unescaped"),
        RESPONSE_BODY_AS_DOCUMENT("as_document"),
        RESPONSE_HEADERS("true"),
        REQUEST_HEADERS("request_headers"),
        REQUEST_URL("URL"),
        RESPONSE_CODE("code"),
        RESPONSE_MESSAGE("message");

        private final String propertyValue;

        private TargetField(String propertyValue) {
            this.propertyValue = propertyValue;
        }
    }
}

