/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.EmbeddedJmeterEngine;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.testelements.TestElementContainer;

public class DslTestPlan
extends TestElementContainer<TestPlanChild> {
    private boolean tearDownAfterMainThreadsShutDown = true;
    private boolean serializeThreadGroups = false;

    public DslTestPlan(List<TestPlanChild> children) {
        super("Test Plan", TestPlanGui.class, children);
    }

    @Override
    protected TestElement buildTestElement() {
        TestPlan ret = new TestPlan();
        ret.setUserDefinedVariables(new Arguments());
        ret.setTearDownOnShutdown(this.tearDownAfterMainThreadsShutDown);
        ret.setSerialized(this.serializeThreadGroups);
        return ret;
    }

    public TestPlanStats run() throws IOException {
        return new EmbeddedJmeterEngine().run(this);
    }

    public TestPlanStats runIn(DslJmeterEngine engine) throws IOException, InterruptedException, TimeoutException {
        return engine.run(this);
    }

    public void saveAsJmx(String filePath) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        try (FileOutputStream output = new FileOutputStream(filePath);){
            ListedHashTree tree = new ListedHashTree();
            this.buildTreeUnder((HashTree)tree, new BuildTreeContext((HashTree)tree));
            env.saveTree((HashTree)tree, output);
        }
    }

    public static DslTestPlan fromJmx(String filePath) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        HashTree tree = env.loadTree(new File(filePath));
        return new JmxTestPlan(tree);
    }

    public DslTestPlan sequentialThreadGroups() {
        this.serializeThreadGroups = true;
        return this;
    }

    public DslTestPlan tearDownOnlyAfterMainThreadsDone() {
        this.tearDownAfterMainThreadsShutDown = false;
        return this;
    }

    public static interface TestPlanChild
    extends DslTestElement {
    }

    private static class JmxTestPlan
    extends DslTestPlan {
        private final HashTree tree;

        private JmxTestPlan(HashTree tree) {
            super(Collections.emptyList());
            this.tree = tree;
        }

        @Override
        public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
            parent.putAll((Map)this.tree);
            return context.getTestPlanTree();
        }
    }
}

