/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.net.URI;
import java.nio.charset.Charset;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.config.gui.HttpDefaultsGui;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.configs.DslConfigElement;
import us.abstracta.jmeter.javadsl.http.DslHttpSampler;

public class DslHttpDefaults
extends DslConfigElement {
    private String url;
    private Charset encoding;
    private boolean downloadEmbeddedResources;
    private DslHttpSampler.HttpClientImpl clientImpl;

    public DslHttpDefaults() {
        super("HTTP Request Defaults", HttpDefaultsGui.class);
    }

    public DslHttpDefaults url(String url) {
        this.url = url;
        return this;
    }

    public DslHttpDefaults encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpDefaults downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpDefaults clientImpl(DslHttpSampler.HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        ConfigTestElement ret = new ConfigTestElement();
        if (this.url != null) {
            URI uri = URI.create(this.url);
            ret.setProperty("HTTPSampler.protocol", uri.getScheme());
            ret.setProperty("HTTPSampler.domain", uri.getHost());
            ret.setProperty("HTTPSampler.port", uri.getPort());
            ret.setProperty("HTTPSampler.path", uri.getRawPath());
        }
        if (this.encoding != null) {
            ret.setProperty("HTTPSampler.contentEncoding", this.encoding.toString());
        }
        if (this.downloadEmbeddedResources) {
            ret.setProperty("HTTPSampler.image_parser", true);
            ret.setProperty("HTTPSampler.concurrentDwn", true);
        }
        if (this.clientImpl != null) {
            ret.setProperty("HTTPSampler.implementation", this.clientImpl.propertyValue);
        }
        return ret;
    }
}

