/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import java.util.function.Consumer;
import org.apache.jmeter.extractor.BoundaryExtractor;
import org.apache.jmeter.extractor.gui.BoundaryExtractorGui;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.postprocessors.DslVariableExtractor;

public class DslBoundaryExtractor
extends DslVariableExtractor<DslBoundaryExtractor> {
    private final String leftBoundary;
    private final String rightBoundary;
    private TargetField fieldToCheck = TargetField.RESPONSE_BODY;

    public DslBoundaryExtractor(String varName, String leftBoundary, String rightBoundary) {
        super(varName, "Boundary Extractor", BoundaryExtractorGui.class);
        this.leftBoundary = leftBoundary;
        this.rightBoundary = rightBoundary;
    }

    public DslBoundaryExtractor matchNumber(int matchNumber) {
        this.matchNumber = matchNumber;
        return this;
    }

    public DslBoundaryExtractor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DslBoundaryExtractor fieldToCheck(TargetField fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        BoundaryExtractor ret = new BoundaryExtractor();
        this.setScopeTo((AbstractScopedTestElement)ret);
        this.fieldToCheck.applyTo(ret);
        ret.setRefName(this.varName);
        ret.setLeftBoundary(this.leftBoundary);
        ret.setRightBoundary(this.rightBoundary);
        ret.setMatchNumber(this.matchNumber);
        if (this.defaultValue != null) {
            if (this.defaultValue.isEmpty()) {
                ret.setDefaultEmptyValue(true);
            } else {
                ret.setDefaultValue(this.defaultValue);
            }
        }
        return ret;
    }

    public static enum TargetField {
        RESPONSE_BODY(BoundaryExtractor::useBody),
        RESPONSE_BODY_UNESCAPED(BoundaryExtractor::useUnescapedBody),
        RESPONSE_BODY_AS_DOCUMENT(BoundaryExtractor::useBodyAsDocument),
        RESPONSE_HEADERS(BoundaryExtractor::useHeaders),
        REQUEST_HEADERS(BoundaryExtractor::useRequestHeaders),
        REQUEST_URL(BoundaryExtractor::useUrl),
        RESPONSE_CODE(BoundaryExtractor::useCode),
        RESPONSE_MESSAGE(BoundaryExtractor::useMessage);

        private final Consumer<BoundaryExtractor> applier;

        private TargetField(Consumer<BoundaryExtractor> applier) {
            this.applier = applier;
        }

        private void applyTo(BoundaryExtractor re) {
            this.applier.accept(re);
        }
    }
}

