/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TestPlanStats {
    protected StatsSummary overallStats;
    protected final Map<String, StatsSummary> labeledStats = new ConcurrentHashMap<String, StatsSummary>();

    public void setLabeledStats(String label, StatsSummary stats) {
        this.labeledStats.put(label, stats);
    }

    public void setOverallStats(StatsSummary stats) {
        this.overallStats = stats;
    }

    public StatsSummary overall() {
        return this.overallStats;
    }

    public StatsSummary byLabel(String label) {
        return this.labeledStats.get(label);
    }

    public Set<String> labels() {
        return this.labeledStats.keySet();
    }

    public static interface StatsSummary {
        public Instant firstTime();

        public Instant endTime();

        public Duration elapsedTime();

        public long samplesCount();

        public double samplesPerSecond();

        public long errorsCount();

        public Duration minSampleTime();

        public Duration maxSampleTime();

        public Duration meanSampleTime();

        public Duration sampleTimePercentile90();

        public Duration sampleTimePercentile95();

        public Duration sampleTimePercentile99();

        public long receivedBytes();

        public double receivedBytesPerSecond();

        public long sentBytes();

        public double sentBytesPerSecond();
    }
}

