/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;

public class DslScriptBuilder {
    private static int currentScriptId = 1;
    protected final String scriptString;
    private final int scriptId;
    private final DslScript<?, ?> script;
    private final Class<?> varsClass;
    private final Map<String, String> varsNameMapping;

    public DslScriptBuilder(DslScript<?, ?> script, Class<?> varsClass, Map<String, String> varsNameMapping) {
        this(currentScriptId++, script, varsClass, varsNameMapping, null);
    }

    private DslScriptBuilder(int scriptId, DslScript<?, ?> script, Class<?> varsClass, Map<String, String> varsNameMapping, String scriptString) {
        this.scriptId = scriptId;
        this.script = script;
        this.varsClass = varsClass;
        this.varsNameMapping = varsNameMapping;
        this.scriptString = scriptString;
    }

    public DslScriptBuilder(String script) {
        this(0, null, null, null, script);
    }

    public String build() {
        return this.scriptString != null ? this.scriptString : "// It is currently not supported to run scripts defined in Java code in JMeter GUI or non Embedded Engine (eg: BlazeMeter).\n" + DslScriptBuilder.buildScriptString(this.registerScriptProperty(), this.varsClass, this.varsNameMapping);
    }

    private String registerScriptProperty() {
        String scriptPropName = "groovyScript" + this.scriptId;
        JMeterUtils.getJMeterProperties().put(scriptPropName, this.script);
        return scriptPropName;
    }

    private static String buildScriptString(String scriptId, Class<?> varsClass, Map<String, String> varsNameMapping) {
        return "props.get('" + scriptId + "').run(new " + varsClass.getName() + "(" + DslScriptBuilder.buildConstructorParameters(varsClass, varsNameMapping) + "))";
    }

    private static String buildConstructorParameters(Class<?> varsClass, Map<String, String> varsNameMapping) {
        return Arrays.stream(varsClass.getFields()).map(Field::getName).map(f -> varsNameMapping.getOrDefault(f, (String)f)).collect(Collectors.joining(","));
    }

    public static abstract class DslScriptVars {
        public final SampleResult prev;
        public final JMeterContext ctx;
        public final JMeterVariables vars;
        public final Properties props;
        public final Sampler sampler;
        public final Logger log;

        public DslScriptVars(SampleResult prev, JMeterContext ctx, JMeterVariables vars, Properties props, Sampler sampler, Logger log) {
            this.prev = prev;
            this.ctx = ctx;
            this.vars = vars;
            this.props = props;
            this.sampler = sampler;
            this.log = log;
        }

        public Map<String, Object> prevMap() {
            Map<String, Object> ret = this.prevMetadata();
            ret.putAll(this.prevMetrics());
            ret.put("request", this.prevRequest());
            ret.put("response", this.prevResponse());
            return ret;
        }

        public Map<String, Object> prevMetadata() {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("label", this.prev.getSampleLabel());
            ret.put("timestamp", Instant.ofEpochMilli(this.prev.getTimeStamp()));
            SampleResult parent = this.prev.getParent();
            if (parent != null) {
                ret.put("parent", parent.getSampleLabel());
            }
            ret.put("successful", this.prev.isSuccessful());
            ret.put("threadName", this.prev.getThreadName());
            ret.put("threadsCount", this.prev.getAllThreads());
            ret.put("threadGroupSize", this.prev.getGroupThreads());
            return ret;
        }

        public Map<String, Object> prevMetrics() {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("sampleMillis", this.prev.getTime());
            ret.put("connectionMillis", this.prev.getConnectTime());
            ret.put("latencyMillis", this.prev.getLatency());
            ret.put("sentBytes", this.prev.getSentBytes());
            ret.put("receivedBytes", this.prev.getBytesAsLong());
            return ret;
        }

        public String prevRequest() {
            return this.prev instanceof HTTPSampleResult ? this.httpRequestString((HTTPSampleResult)this.prev) : this.prev.getRequestHeaders() + "\n" + this.prev.getSamplerData();
        }

        private String httpRequestString(HTTPSampleResult result) {
            String cookiesHeader = result.getCookies();
            if (cookiesHeader != null && !cookiesHeader.isEmpty()) {
                cookiesHeader = "Cookie: " + cookiesHeader + "\n";
            }
            return result.getHTTPMethod() + " " + result.getUrlAsString() + "\n" + result.getRequestHeaders() + cookiesHeader + "\n" + result.getQueryString();
        }

        public String prevResponse() {
            String statusLine = this.prev instanceof HTTPSampleResult ? "" : this.prev.getResponseCode() + " " + this.prev.getResponseMessage() + "\n";
            return statusLine + this.prev.getResponseHeaders() + "\n" + this.prev.getResponseDataAsString();
        }

        public Map<String, Object> varsMap() {
            return this.vars.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static interface DslScript<P extends DslScriptVars, R> {
        public R run(P var1) throws Exception;
    }
}

