/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.parallel;

import com.blazemeter.jmeter.controller.ParallelControllerGui;
import com.blazemeter.jmeter.controller.ParallelSampler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.controllers.DslController;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;

public class ParallelController
extends DslController {
    private boolean generateParent = false;
    private Integer maxThreads;

    public ParallelController(String name, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(name == null ? "bzm - Parallel Controller" : name, ParallelControllerGui.class, children);
    }

    public static ParallelController parallelController(BaseThreadGroup.ThreadGroupChild ... children) {
        return new ParallelController(null, Arrays.asList(children));
    }

    public static ParallelController parallelController(String name, BaseThreadGroup.ThreadGroupChild ... children) {
        return new ParallelController(name, Arrays.asList(children));
    }

    public static ParallelController parallelController() {
        return ParallelController.parallelController(new BaseThreadGroup.ThreadGroupChild[]{new ParallelController(null, Collections.emptyList())});
    }

    public static ParallelController parallelController(String name) {
        return new ParallelController(name, Collections.emptyList());
    }

    public ParallelController generateParentSample(boolean generateParent) {
        this.generateParent = generateParent;
        return this;
    }

    public ParallelController maxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public ParallelController children(BaseThreadGroup.ThreadGroupChild ... children) {
        this.addChildren((DslTestElement[])children);
        return this;
    }

    protected TestElement buildTestElement() {
        ParallelSampler ret = new ParallelSampler();
        ret.setGenerateParent(this.generateParent);
        if (this.maxThreads != null) {
            ret.setMaxThreadNumber(this.maxThreads.intValue());
            ret.setLimitMaxThreadNumber(true);
        }
        return ret;
    }
}

