/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;

public class DslJdbcConnectionPool
extends BaseConfigElement {
    private static final Map<Integer, String> TRANSACTION_ISOLATION_TO_PROPERTY_VALUE = DslJdbcConnectionPool.buildTransactionIsolationToPropertyValueMapping();
    private static final Duration DEFAULT_MAX_CONNECTION_WAIT = Duration.ofSeconds(10L);
    private static final int DEFAULT_TRANSACTION_ISOLATION = -1;
    private static final String DEFAULT_PROPERTY_VALUE = "DEFAULT";
    protected Class<? extends Driver> driverClass;
    protected String url;
    protected String user;
    protected String password;
    protected boolean autoCommit = true;
    protected int maxConnections;
    protected Duration maxConnectionWait = DEFAULT_MAX_CONNECTION_WAIT;
    protected int transactionIsolation = -1;

    public DslJdbcConnectionPool(String name, Class<? extends Driver> driverClass, String url) {
        super(name, TestBeanGUI.class);
        this.driverClass = driverClass;
        this.url = url;
    }

    private static Map<Integer, String> buildTransactionIsolationToPropertyValueMapping() {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        ret.put(-1, DEFAULT_PROPERTY_VALUE);
        ret.put(0, "TRANSACTION_NONE");
        ret.put(2, "TRANSACTION_READ_COMMITTED");
        ret.put(1, "TRANSACTION_READ_UNCOMMITTED");
        ret.put(4, "TRANSACTION_REPEATABLE_READ");
        ret.put(8, "TRANSACTION_SERIALIZABLE");
        return ret;
    }

    public DslJdbcConnectionPool user(String user) {
        this.user = user;
        return this;
    }

    public DslJdbcConnectionPool password(String password) {
        this.password = password;
        return this;
    }

    public DslJdbcConnectionPool autoCommit(boolean enabled) {
        this.autoCommit = enabled;
        return this;
    }

    public DslJdbcConnectionPool maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public DslJdbcConnectionPool maxConnectionWait(Duration maxConnectionWait) {
        this.maxConnectionWait = maxConnectionWait;
        return this;
    }

    public DslJdbcConnectionPool transactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
        return this;
    }

    protected TestElement buildTestElement() {
        DataSourceElement ret = new DataSourceElement();
        ret.setDataSource(this.name);
        ret.setDriver(this.driverClass.getName());
        ret.setDbUrl(this.url);
        ret.setUsername(this.user);
        ret.setPassword(this.password);
        ret.setAutocommit(this.autoCommit);
        ret.setPoolMax(String.valueOf(this.maxConnections));
        ret.setTimeout(String.valueOf(this.maxConnectionWait.toMillis()));
        ret.setTransactionIsolation(this.transactionIsolationToPropertyValue(this.transactionIsolation));
        ret.setPreinit(true);
        return ret;
    }

    private String transactionIsolationToPropertyValue(int val) {
        return Optional.ofNullable(TRANSACTION_ISOLATION_TO_PROPERTY_VALUE.get(val)).orElseThrow(() -> new IllegalArgumentException("Unknown transaction level " + val + " for pool " + this.name));
    }

    private static class TransactionIsolationParam
    extends MethodParam {
        protected TransactionIsolationParam(String expression) {
            super(Integer.TYPE, expression);
        }

        public boolean isDefault() {
            return this.expression == null || DslJdbcConnectionPool.DEFAULT_PROPERTY_VALUE.equals(this.expression);
        }

        public Set<String> getImports() {
            return DslJdbcConnectionPool.DEFAULT_PROPERTY_VALUE.equals(this.expression) ? Collections.emptySet() : Collections.singleton(Connection.class.getName());
        }

        protected String buildCode(String indent) {
            return DslJdbcConnectionPool.DEFAULT_PROPERTY_VALUE.equals(this.expression) ? "-1" : "Connection." + this.expression;
        }
    }

    private static class ClassParam
    extends MethodParam {
        private final String className;

        private ClassParam(String className) {
            super(Class.class, null);
            this.className = className;
        }

        public Set<String> getImports() {
            return Collections.singleton(this.className);
        }

        protected String buildCode(String indent) {
            return this.className.substring(this.className.lastIndexOf(".") + 1) + ".class";
        }
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<DataSourceElement> {
        public CodeBuilder(List<Method> builderMethods) {
            super(DataSourceElement.class, builderMethods);
        }

        protected MethodCall buildMethodCall(DataSourceElement testElement, MethodCallContext context) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement);
            return this.buildMethodCall(new MethodParam[]{paramBuilder.stringParam("dataSource"), new ClassParam(testElement.getPropertyAsString("driver")), paramBuilder.stringParam("dbUrl")}).chain("user", new MethodParam[]{paramBuilder.stringParam("username")}).chain("password", new MethodParam[]{paramBuilder.stringParam("password")}).chain("autoCommit", new MethodParam[]{paramBuilder.boolParam("autocommit", true)}).chain("maxConnections", new MethodParam[]{paramBuilder.intParam("poolMax", Integer.valueOf(0))}).chain("maxConnectionWait", new MethodParam[]{paramBuilder.durationParamMillis("timeout", DEFAULT_MAX_CONNECTION_WAIT)}).chain("transactionIsolation", new MethodParam[]{new TransactionIsolationParam(testElement.getPropertyAsString("transactionIsolation"))});
        }
    }
}

