/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import us.abstracta.jmeter.javadsl.blazemeter.api.Test;

public class TestRun {
    private final long id;
    private final String reportStatus;
    private final List<ReportMessage> aggregatedMessages;
    private String url;

    @JsonCreator
    private TestRun(@JsonProperty(value="id") long id, @JsonProperty(value="reportStatus") String reportStatus, @JsonProperty(value="aggregatedMessages") List<ReportMessage> aggregatedMessages) {
        this.id = id;
        this.reportStatus = reportStatus;
        this.aggregatedMessages = aggregatedMessages;
    }

    public void setTest(Test test) {
        this.url = test.getProject().getUrl() + "/masters/" + this.id;
    }

    public long getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isErrorStatus() {
        return "error".equals(this.reportStatus);
    }

    public List<String> getErrorMessages() {
        return this.aggregatedMessages.stream().filter(m -> "ERROR".equals(((ReportMessage)m).level)).map(m -> ((ReportMessage)m).message).collect(Collectors.toList());
    }

    private static class ReportMessage {
        private final String message;
        private final String level;

        @JsonCreator
        private ReportMessage(@JsonProperty(value="message") String message, @JsonProperty(value="level") String level) {
            this.message = message;
            this.level = level;
        }
    }
}

