/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import devcsrj.okhttp3.logging.HttpLoggingInterceptor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterException;
import us.abstracta.jmeter.javadsl.blazemeter.api.ApiResponse;
import us.abstracta.jmeter.javadsl.blazemeter.api.Project;
import us.abstracta.jmeter.javadsl.blazemeter.api.Test;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRun;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunStatus;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.User;
import us.abstracta.jmeter.javadsl.blazemeter.api.Workspace;

public class BlazeMeterClient {
    private static final Logger LOG = LoggerFactory.getLogger(BlazeMeterClient.class);
    private static final int WARNING_EVENT_LEVEL = 300;
    private final BlazeMeterApi api;

    public BlazeMeterClient(String apiUrl, String authToken) {
        this.api = (BlazeMeterApi)new Retrofit.Builder().baseUrl(apiUrl).addConverterFactory((Converter.Factory)this.buildConverterFactory()).client(this.buildHttpClient(authToken)).build().create(BlazeMeterApi.class);
    }

    private JacksonConverterFactory buildConverterFactory() {
        return JacksonConverterFactory.create((ObjectMapper)new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule()));
    }

    private OkHttpClient buildHttpClient(String token) {
        int tokenSeparatorIndex = token.indexOf(58);
        if (tokenSeparatorIndex < 0) {
            throw new IllegalArgumentException("BlazeMeter token does not match with expected format: <apikey>:<secretKey>");
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request request = chain.request().newBuilder().header("Authorization", Credentials.basic((String)token.substring(0, tokenSeparatorIndex), (String)token.substring(tokenSeparatorIndex + 1))).build();
            return chain.proceed(request);
        });
        if (LOG.isDebugEnabled()) {
            builder.addInterceptor((Interceptor)new HttpLoggingInterceptor());
        }
        return builder.build();
    }

    public Project findDefaultProject(String baseUrl) throws IOException {
        Project ret = this.execApiCall(this.api.findUser()).getDefaultProject();
        ret.setBaseUrl(baseUrl);
        return ret;
    }

    public Project findProjectById(Long projectId, String baseUrl) throws IOException {
        Project ret = this.execApiCall(this.api.findProject(projectId));
        ret.setAccountId(this.execApiCall(this.api.findWorkspace(ret.getWorkspaceId())).getAccountId());
        ret.setBaseUrl(baseUrl);
        return ret;
    }

    private <T> T execApiCall(Call<ApiResponse<T>> call) throws IOException {
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw new BlazeMeterException(response.code(), response.errorBody().string());
        }
        return ((ApiResponse)response.body()).getResult();
    }

    public Optional<Test> findTestByName(String testName, Project project) throws IOException {
        List<Test> tests = this.execApiCall(this.api.findTests(project.getId(), testName));
        if (tests.isEmpty()) {
            return Optional.empty();
        }
        Test test = tests.get(0);
        test.setProject(project);
        return Optional.of(test);
    }

    public Test createTest(TestConfig testConfig, Project project) throws IOException {
        Test ret = this.execApiCall(this.api.createTest(testConfig));
        ret.setProject(project);
        return ret;
    }

    public void updateTest(Test test, TestConfig testConfig) throws IOException {
        this.execApiCall(this.api.updateTest(test.getId(), testConfig));
    }

    public void uploadTestFile(Test test, File jmxFile) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/octet-stream"), (File)jmxFile);
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)jmxFile.getName(), (RequestBody)requestBody);
        this.execApiCall(this.api.uploadTestFile(test.getId(), part));
    }

    public TestRun startTest(Test test, TestRunConfig runConfig) throws IOException {
        TestRun ret = this.execApiCall(this.api.startTest(test.getId(), runConfig));
        ret.setTest(test);
        return ret;
    }

    public TestRunStatus findTestRunStatus(TestRun testRun) throws IOException {
        return this.execApiCall(this.api.findTestRunStatus(testRun.getId(), 300));
    }

    public TestRunSummaryStats findTestRunSummaryStats(TestRun testRun) throws IOException {
        return this.execApiCall(this.api.findTestRunSummaryStats(testRun.getId()));
    }

    public List<TestRunRequestStats> findTestRunRequestStats(TestRun testRun) throws IOException {
        return this.execApiCall(this.api.findTestRunRequestStats(testRun.getId()));
    }

    private static interface BlazeMeterApi {
        @GET(value="user")
        public Call<ApiResponse<User>> findUser();

        @GET(value="projects/{projectId}")
        public Call<ApiResponse<Project>> findProject(@Path(value="projectId") long var1);

        @GET(value="workspaces/{workspaceId}")
        public Call<ApiResponse<Workspace>> findWorkspace(@Path(value="workspaceId") long var1);

        @GET(value="tests")
        public Call<ApiResponse<List<Test>>> findTests(@Query(value="projectId") long var1, @Query(value="name") String var3);

        @PATCH(value="tests/{testId}")
        public Call<ApiResponse<Void>> updateTest(@Path(value="testId") long var1, @Body TestConfig var3);

        @POST(value="tests")
        public Call<ApiResponse<Test>> createTest(@Body TestConfig var1);

        @POST(value="tests/{testId}/files")
        @Multipart
        public Call<ApiResponse<Void>> uploadTestFile(@Path(value="testId") long var1, @Part MultipartBody.Part var3);

        @POST(value="tests/{testId}/start")
        public Call<ApiResponse<TestRun>> startTest(@Path(value="testId") long var1, @Body TestRunConfig var3);

        @GET(value="masters/{testRunId}/status")
        public Call<ApiResponse<TestRunStatus>> findTestRunStatus(@Path(value="testRunId") long var1, @Query(value="level") int var3);

        @GET(value="masters/{testRunId}/reports/default/summary")
        public Call<ApiResponse<TestRunSummaryStats>> findTestRunSummaryStats(@Path(value="testRunId") long var1);

        @GET(value="masters/{testRunId}/reports/aggregatereport/data")
        public Call<ApiResponse<List<TestRunRequestStats>>> findTestRunRequestStats(@Path(value="testRunId") long var1);
    }
}

