/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterClient;
import us.abstracta.jmeter.javadsl.blazemeter.api.Project;
import us.abstracta.jmeter.javadsl.blazemeter.api.Test;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRun;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunStatus;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.stats.CountMetricSummary;
import us.abstracta.jmeter.javadsl.core.stats.StatsSummary;
import us.abstracta.jmeter.javadsl.core.stats.TimeMetricSummary;

public class BlazeMeterEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BlazeMeterEngine.class);
    private static final String BASE_URL = "https://a.blazemeter.com";
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private final BlazeMeterClient client;
    private String testName = "jmeter-java-dsl";
    private Long projectId;
    private Duration testTimeout = Duration.ofHours(1L);
    private Duration availableDataTimeout = Duration.ofSeconds(30L);
    private Integer totalUsers;
    private Duration rampUp;
    private Integer iterations;
    private Duration holdFor;
    private Integer threadsPerEngine;
    private boolean useDebugRun;

    public BlazeMeterEngine(String authToken) {
        this.client = new BlazeMeterClient("https://a.blazemeter.com/api/v4/", authToken);
    }

    public BlazeMeterEngine testName(String testName) {
        this.testName = testName;
        return this;
    }

    public BlazeMeterEngine projectId(long projectId) {
        this.projectId = projectId;
        return this;
    }

    public BlazeMeterEngine testTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    public BlazeMeterEngine availableDataTimeout(Duration availableDataTimeout) {
        this.availableDataTimeout = availableDataTimeout;
        return this;
    }

    public BlazeMeterEngine totalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
        return this;
    }

    public BlazeMeterEngine rampUpFor(Duration rampUp) {
        this.rampUp = rampUp;
        return this;
    }

    public BlazeMeterEngine iterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public BlazeMeterEngine holdFor(Duration holdFor) {
        this.holdFor = holdFor;
        return this;
    }

    public BlazeMeterEngine threadsPerEngine(int threadsPerEngine) {
        this.threadsPerEngine = threadsPerEngine;
        return this;
    }

    public BlazeMeterEngine useDebugRun() {
        this.useDebugRun = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlazeMeterTestPlanStats run(DslTestPlan testPlan) throws IOException, InterruptedException, TimeoutException {
        Project project = this.findProject();
        File jmxFile = Files.createTempDirectory("jmeter-dsl", new FileAttribute[0]).resolve("test.jmx").toFile();
        try {
            this.saveTestPlanTo(testPlan, jmxFile);
            Test test = this.client.findTestByName(this.testName, project).orElse(null);
            TestConfig testConfig = this.buildTestConfig(project, jmxFile);
            if (test != null) {
                this.client.updateTest(test, testConfig);
                LOG.info("Updated test {}", (Object)test.getUrl());
            } else {
                test = this.client.createTest(testConfig, project);
                LOG.info("Created test {}", (Object)test.getUrl());
            }
            this.client.uploadTestFile(test, jmxFile);
            TestRun testRun = this.client.startTest(test, this.buildTestRunConfig());
            LOG.info("Started test run {}", (Object)testRun.getUrl());
            this.awaitTestEnd(testRun);
            BlazeMeterTestPlanStats blazeMeterTestPlanStats = this.findTestPlanStats(testRun);
            return blazeMeterTestPlanStats;
        }
        finally {
            if (jmxFile.delete()) {
                jmxFile.getParentFile().delete();
            }
        }
    }

    private Project findProject() throws IOException {
        String appBaseUrl = "https://a.blazemeter.com/app/#";
        return this.projectId == null ? this.client.findDefaultProject(appBaseUrl) : this.client.findProjectById(this.projectId, appBaseUrl);
    }

    private void saveTestPlanTo(DslTestPlan testPlan, File jmxFile) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        try (FileOutputStream output = new FileOutputStream(jmxFile.getPath());){
            ListedHashTree tree = new ListedHashTree();
            BuildTreeContext context = new BuildTreeContext((HashTree)tree);
            testPlan.buildTreeUnder((HashTree)tree, context);
            env.saveTree((HashTree)tree, output);
            context.getVisualizers().forEach((v, e) -> LOG.warn("BlazeMeterEngine does not currently support displaying visualizers. Ignoring {}.", (Object)v.getClass().getSimpleName()));
        }
    }

    private TestConfig buildTestConfig(Project project, File jmxFile) {
        return new TestConfig().name(this.testName).projectId(project.getId()).jmxFile(jmxFile).totalUsers(this.totalUsers).rampUp(this.rampUp).iterations(this.iterations).holdFor(this.holdFor).threadsPerEngine(this.threadsPerEngine);
    }

    private TestRunConfig buildTestRunConfig() {
        TestRunConfig ret = new TestRunConfig();
        if (this.useDebugRun) {
            ret.debugRun();
        }
        return ret;
    }

    private void awaitTestEnd(TestRun testRun) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status = TestRunStatus.CREATED;
        Instant testStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            TestRunStatus newStatus = this.client.findTestRunStatus(testRun);
            if (status.equals(newStatus)) continue;
            LOG.debug("Test run {} status changed to: {}", (Object)testRun.getUrl(), (Object)newStatus);
            status = newStatus;
        } while (!TestRunStatus.ENDED.equals(status) && !this.hasTimedOut(testStart, this.testTimeout));
        if (!TestRunStatus.ENDED.equals(status)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            this.awaitAvailableData(testRun, testStart);
        }
    }

    private boolean hasTimedOut(Instant start, Duration timeout) {
        return Duration.between(start, Instant.now()).compareTo(timeout) >= 0;
    }

    private TimeoutException buildTestTimeoutException(TestRun testRun) {
        return new TimeoutException(String.format("Test %s didn't end after %s. If the timeout is too short, you can change it with testTimeout() method.", testRun.getUrl(), this.testTimeout));
    }

    private void awaitAvailableData(TestRun testRun, Instant testStart) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status;
        Instant dataPollStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
        } while (!(status = this.client.findTestRunStatus(testRun)).isDataAvailable() && !this.hasTimedOut(testStart, this.testTimeout) && !this.hasTimedOut(dataPollStart, this.availableDataTimeout));
        if (this.hasTimedOut(testStart, this.testTimeout)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            throw new TimeoutException(String.format("Test %s ended, but no data is available after %s. This is usually caused by some failure in BlazeMeter. Check bzt.log and jmeter.out, and if everything looks good you might try increasing this timeout with availableDataTimeout() method.", testRun.getUrl(), this.availableDataTimeout));
        }
    }

    private BlazeMeterTestPlanStats findTestPlanStats(TestRun testRun) throws IOException {
        TestRunSummaryStats.TestRunLabeledSummary summary = this.client.findTestRunSummaryStats(testRun).getSummary().get(0);
        List<TestRunRequestStats> labeledStats = this.client.findTestRunRequestStats(testRun);
        return this.buildTestStats(summary, labeledStats);
    }

    private BlazeMeterTestPlanStats buildTestStats(TestRunSummaryStats.TestRunLabeledSummary summary, List<TestRunRequestStats> labeledStats) {
        BlazeMeterTestPlanStats stats = new BlazeMeterTestPlanStats();
        for (TestRunRequestStats labeledStat : labeledStats) {
            BlazemeterStatsSummary labelStatsSummary = new BlazemeterStatsSummary(labeledStat, summary);
            if ("ALL".equals(labeledStat.getLabelName())) {
                stats.setOverallStats(labelStatsSummary);
                stats.setStart(labelStatsSummary.firstTime);
                stats.setEnd(labelStatsSummary.endTime);
                continue;
            }
            stats.setLabeledStats(labeledStat.getLabelName(), labelStatsSummary);
        }
        return stats;
    }

    public static class BlazeMeterTimeMetricSummary
    implements TimeMetricSummary {
        private final Duration min;
        private final Duration max;
        private final Duration mean;
        private final Duration median;
        private final Duration percentile90;
        private final Duration percentile95;
        private final Duration percentile99;

        private BlazeMeterTimeMetricSummary(long min, long max, double mean, double median, double percentile90, double percentile95, double percentile99) {
            this.min = Duration.ofMillis(min);
            this.max = Duration.ofMillis(max);
            this.mean = this.double2Duration(mean);
            this.median = this.double2Duration(median);
            this.percentile90 = this.double2Duration(percentile90);
            this.percentile95 = this.double2Duration(percentile95);
            this.percentile99 = this.double2Duration(percentile99);
        }

        private Duration double2Duration(double millis) {
            return Duration.ofMillis(Math.round(millis));
        }

        public Duration min() {
            return this.min;
        }

        public Duration max() {
            return this.max;
        }

        public Duration mean() {
            return this.mean;
        }

        public Duration median() {
            return this.median;
        }

        public Duration perc90() {
            return this.percentile90;
        }

        public Duration perc95() {
            return this.percentile95;
        }

        public Duration perc99() {
            return this.percentile99;
        }
    }

    public static class BlazemeterStatsSummary
    implements StatsSummary {
        private final Instant firstTime;
        private final Instant endTime;
        private final CountMetricSummary samples = new CountMetricSummary();
        private final CountMetricSummary errors = new CountMetricSummary();
        private final CountMetricSummary receivedBytes = new CountMetricSummary();
        private final BlazeMeterTimeMetricSummary sampleTime;

        private BlazemeterStatsSummary(TestRunRequestStats labeledStat, TestRunSummaryStats.TestRunLabeledSummary summary) {
            this.firstTime = summary.getFirst();
            this.endTime = summary.getLast();
            long elapsedTimeMillis = labeledStat.getDuration();
            this.samples.increment(labeledStat.getSamples(), elapsedTimeMillis);
            this.errors.increment(labeledStat.getErrorsCount(), elapsedTimeMillis);
            this.sampleTime = new BlazeMeterTimeMetricSummary(labeledStat.getMinResponseTime(), labeledStat.getMaxResponseTime(), labeledStat.getAvgResponseTime(), labeledStat.getMedianResponseTime(), labeledStat.getPerc90(), labeledStat.getPerc95(), labeledStat.getPerc99());
            this.receivedBytes.increment(Math.round(labeledStat.getAvgBytes() / 1000.0 * (double)elapsedTimeMillis), elapsedTimeMillis);
        }

        public void add(SampleResult result) {
        }

        public Instant firstTime() {
            return this.firstTime;
        }

        public Instant endTime() {
            return this.endTime;
        }

        public CountMetricSummary samples() {
            return this.samples;
        }

        public CountMetricSummary errors() {
            return this.errors;
        }

        public BlazeMeterTimeMetricSummary sampleTime() {
            return this.sampleTime;
        }

        public CountMetricSummary receivedBytes() {
            return this.receivedBytes;
        }

        public CountMetricSummary sentBytes() {
            throw new UnsupportedOperationException("BlazeMeter API does not provide an efficient way to get this value.");
        }
    }

    public static class BlazeMeterTestPlanStats
    extends TestPlanStats {
        public BlazeMeterTestPlanStats() {
            super(() -> null);
        }

        public void setLabeledStats(String label, StatsSummary stats) {
            this.labeledStats.put(label, stats);
        }

        public void setOverallStats(StatsSummary stats) {
            this.overallStats = stats;
        }
    }
}

