/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import java.util.Objects;
import uk.sky.cqlmigrate.LockConfig;

public class CqlMigratorConfig {
    private final LockConfig cassandraLockConfig;
    private final ConsistencyLevel readConsistencyLevel;
    private final ConsistencyLevel writeConsistencyLevel;

    private CqlMigratorConfig(LockConfig cassandraLockConfig, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        this.cassandraLockConfig = Objects.requireNonNull(cassandraLockConfig);
        this.readConsistencyLevel = Objects.requireNonNull(readConsistencyLevel);
        this.writeConsistencyLevel = Objects.requireNonNull(writeConsistencyLevel);
    }

    public static CassandraConfigBuilder builder() {
        return new CassandraConfigBuilder();
    }

    public LockConfig getCassandraLockConfig() {
        return this.cassandraLockConfig;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public static class CassandraConfigBuilder {
        private LockConfig lockConfig;
        private ConsistencyLevel readConsistencyLevel;
        private ConsistencyLevel writeConsistencyLevel;

        private CassandraConfigBuilder() {
        }

        public CassandraConfigBuilder withLockConfig(LockConfig cassandraLockConfig) {
            this.lockConfig = cassandraLockConfig;
            return this;
        }

        public CassandraConfigBuilder withReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
            this.readConsistencyLevel = readConsistencyLevel;
            return this;
        }

        public CassandraConfigBuilder withWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
            this.writeConsistencyLevel = writeConsistencyLevel;
            return this;
        }

        public CqlMigratorConfig build() {
            return new CqlMigratorConfig(this.lockConfig, this.readConsistencyLevel, this.writeConsistencyLevel);
        }
    }
}

