/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.session.Session;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.exception.ClusterUnhealthyException;

class ClusterHealth {
    private static final Logger log = LoggerFactory.getLogger(ClusterHealth.class);
    private final Session session;

    ClusterHealth(Session session) {
        this.session = session;
    }

    void check() throws ClusterUnhealthyException {
        log.debug("Checking session health");
        Map nodes = this.session.getMetadata().getNodes();
        List unhealthyHosts = nodes.values().stream().filter(node -> node.getState().equals((Object)NodeState.DOWN)).map(node -> ((InetSocketAddress)node.getBroadcastAddress().get()).getAddress()).collect(Collectors.toList());
        if (!unhealthyHosts.isEmpty()) {
            throw new ClusterUnhealthyException("Cluster not healthy, the following hosts are down: " + unhealthyHosts);
        }
        log.debug("All hosts healthy: {}", nodes.values());
    }
}

