/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class ChecksumCalculator {
    ChecksumCalculator() {
    }

    static String calculateChecksum(Path path) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hash = digest.digest(Files.readAllBytes(path));
            return ChecksumCalculator.bytesToHex(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            int asUnsigned = Byte.toUnsignedInt(b);
            builder.append(Character.forDigit(asUnsigned >>> 4, 16)).append(Character.forDigit(asUnsigned & 0xF, 16));
        }
        return builder.toString();
    }
}

