/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.LockingMechanism;
import uk.sky.cqlmigrate.exception.CannotAcquireLockException;
import uk.sky.cqlmigrate.exception.CannotReleaseLockException;

class CassandraLockingMechanism
extends LockingMechanism {
    private static final Logger log = LoggerFactory.getLogger(CassandraLockingMechanism.class);
    private final CqlSession session;
    private final ConsistencyLevel consistencyLevel;
    private final String lockKeyspace;
    private PreparedStatement selectLockQuery;
    private PreparedStatement insertLockQuery;
    private PreparedStatement deleteLockQuery;
    private boolean isRetryAfterWriteTimeout;

    public CassandraLockingMechanism(CqlSession session, String keyspace, ConsistencyLevel consistencyLevel, String lockKeyspace) {
        super(keyspace + ".schema_migration");
        this.session = session;
        this.consistencyLevel = consistencyLevel;
        this.lockKeyspace = lockKeyspace;
    }

    @Override
    public void init() throws CannotAcquireLockException {
        super.init();
        try {
            String selectQuery = String.format("SELECT name,client FROM %s.locks LIMIT 1", this.lockKeyspace);
            String insertQuery = String.format("INSERT INTO %s.locks (name, client) VALUES (?, ?) IF NOT EXISTS", this.lockKeyspace);
            String deleteQuery = String.format("DELETE FROM %s.locks WHERE name = ? IF client = ?", this.lockKeyspace);
            this.selectLockQuery = this.session.prepare((SimpleStatement)SimpleStatement.newInstance((String)selectQuery).setConsistencyLevel(this.consistencyLevel));
            this.insertLockQuery = this.session.prepare((SimpleStatement)SimpleStatement.newInstance((String)insertQuery).setConsistencyLevel(this.consistencyLevel));
            this.deleteLockQuery = this.session.prepare((SimpleStatement)SimpleStatement.newInstance((String)deleteQuery).setConsistencyLevel(this.consistencyLevel));
        }
        catch (DriverException e) {
            throw new CannotAcquireLockException("Query to prepare locks queries failed", e);
        }
    }

    @Override
    public boolean acquire(String clientId) throws CannotAcquireLockException {
        try {
            this.verifyClusterIsHealthy();
            ResultSet resultSet = this.session.execute((Statement)this.insertLockQuery.bind(new Object[]{this.lockName, clientId}));
            Row currentLock = (Row)resultSet.one();
            if (currentLock.getBoolean("[applied]") || clientId.equals(currentLock.getString("client"))) {
                return true;
            }
            log.info("Lock currently held by {}", (Object)currentLock);
            return false;
        }
        catch (WriteTimeoutException wte) {
            log.warn("Query to acquire lock for {} failed to execute: {}", (Object)clientId, (Object)wte.getMessage());
            return false;
        }
        catch (DriverException de) {
            throw new CannotAcquireLockException(String.format("Query to acquire lock %s for client %s failed to execute", this.lockName, clientId), de);
        }
    }

    private void verifyClusterIsHealthy() {
        this.session.execute((Statement)this.selectLockQuery.bind(new Object[0]));
    }

    @Override
    public boolean release(String clientId) throws CannotReleaseLockException {
        try {
            boolean noLockExists;
            ResultSet resultSet = this.session.execute((Statement)this.deleteLockQuery.bind(new Object[]{this.lockName, clientId}));
            Row result = (Row)resultSet.one();
            boolean bl = noLockExists = !result.getColumnDefinitions().contains("client");
            if (result.getBoolean("[applied]") || noLockExists) {
                log.info("Lock released for {} by client {} at: {}", new Object[]{this.lockName, clientId, System.currentTimeMillis()});
                return true;
            }
            String clientReleasingLock = result.getString("client");
            if (!clientReleasingLock.equals(clientId)) {
                if (this.isRetryAfterWriteTimeout) {
                    log.info("Released lock for client {} in retry attempt after WriteTimeoutException", (Object)clientReleasingLock);
                    return true;
                }
                throw new CannotReleaseLockException(String.format("Lock %s attempted to be released by a non lock holder (%s). Current lock holder: %s", this.lockName, clientId, clientReleasingLock));
            }
            log.error("Delete lock query did not get applied but client is still {}. This should never happen.", (Object)clientId);
            return false;
        }
        catch (WriteTimeoutException e) {
            this.isRetryAfterWriteTimeout = true;
            return false;
        }
        catch (DriverException e) {
            log.error("Query to release lock failed to execute for {} by client {}", new Object[]{this.lockName, clientId, e});
            throw new CannotReleaseLockException("Query failed to execute", e);
        }
    }
}

