/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CqlLoader;
import uk.sky.cqlmigrate.SessionContext;

class SchemaUpdates {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUpdates.class);
    private static final String SCHEMA_UPDATES_TABLE = "schema_updates";
    private static final String CHECKSUM_COLUMN = "checksum";
    private final SessionContext sessionContext;
    private final String keyspace;

    SchemaUpdates(SessionContext sessionContext, String keyspace) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
    }

    void initialise() {
        Session session = this.sessionContext.getSession();
        session.execute(new SimpleStatement("USE " + this.keyspace + ";").setConsistencyLevel(this.sessionContext.getReadConsistencyLevel()));
        TableMetadata schemaUpdateTableMetadata = session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(SCHEMA_UPDATES_TABLE);
        if (schemaUpdateTableMetadata == null) {
            CqlLoader.load(this.sessionContext, Collections.singletonList("CREATE TABLE schema_updates (filename text primary key, checksum text, applied_on timestamp);"));
        }
    }

    boolean alreadyApplied(String filename) {
        Row row = this.getSchemaUpdate(this.sessionContext.getSession(), filename);
        return row != null;
    }

    private Row getSchemaUpdate(Session session, String filename) {
        return session.execute(new SimpleStatement("SELECT * FROM schema_updates where filename = ?", new Object[]{filename}).setConsistencyLevel(this.sessionContext.getReadConsistencyLevel())).one();
    }

    boolean contentsAreDifferent(String filename, Path path) {
        Row row = Objects.requireNonNull(this.getSchemaUpdate(this.sessionContext.getSession(), filename));
        String previousSha1 = row.getString(CHECKSUM_COLUMN);
        try {
            String checksum = this.calculateChecksum(path);
            return !previousSha1.equals(checksum);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void add(String filename, Path path) {
        String query = "INSERT INTO schema_updates (filename, checksum, applied_on) VALUES (?, ?, dateof(now()));";
        Statement statement = new SimpleStatement(query, new Object[]{filename, this.calculateChecksum(path)}).setConsistencyLevel(this.sessionContext.getWriteConsistencyLevel());
        LOGGER.debug("Applying schema cql: {} path: {}", (Object)query, (Object)path);
        this.sessionContext.getSession().execute(statement);
    }

    private String calculateChecksum(Path path) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hash = digest.digest(Files.readAllBytes(path));
            return SchemaUpdates.bytesToHex(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            int asUnsigned = Byte.toUnsignedInt(b);
            builder.append(Character.forDigit(asUnsigned >>> 4, 16)).append(Character.forDigit(asUnsigned & 0xF, 16));
        }
        return builder.toString();
    }
}

