/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.SessionContext;

class CqlLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CqlLoader.class);

    private CqlLoader() {
    }

    static void load(SessionContext sessionContext, List<String> cqlStatements) {
        if (!cqlStatements.isEmpty()) {
            sessionContext.checkClusterHealth();
        }
        try {
            cqlStatements.stream().map(stringStatement -> new SimpleStatement(stringStatement).setConsistencyLevel(sessionContext.getWriteConsistencyLevel())).forEach(statement -> {
                LOGGER.debug("Executing cql statement {}", statement);
                sessionContext.getSession().execute(statement);
            });
        }
        catch (DriverException e) {
            LOGGER.error("Failed to execute cql statements {}: {}", cqlStatements, (Object)e.getMessage());
            throw e;
        }
    }
}

