/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;

public class HasValueWithLooseType
implements Condition {
    private Object expected;

    public HasValueWithLooseType(Object expected) {
        this.expected = expected;
    }

    @Override
    public Result test(JsonNode node) {
        String was = node.toString();
        if (this.expected == null && node.isNull()) {
            return new Result(this.describe(), was, true);
        }
        if (this.expected == null) {
            return new Result(this.describe(), was, false);
        }
        if (this.expected instanceof Number) {
            if (node.isNumber()) {
                return new Result(this.describe(), was, node.numberValue().equals(this.expected));
            }
            return new Result(this.describe(), was, false);
        }
        if (this.expected instanceof String && node.isTextual()) {
            return new Result(this.describe(), was, node.textValue().equals(this.expected));
        }
        if (this.expected instanceof Boolean && node.isBoolean()) {
            return new Result(this.describe(), was, node.booleanValue() == ((Boolean)this.expected).booleanValue());
        }
        return new Result(this.describe(), was, false);
    }

    @Override
    public String describe() {
        return "is equal to " + this.expected;
    }
}

