/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import uk.org.webcompere.modelassert.json.JsonProvider;

public class JsonProviders {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = JsonProviders.defaultObjectMapper();
    private static final ObjectMapper DEFAULT_YAML_MAPPER = JsonProviders.defaultYamlMapper();
    private static ThreadLocal<ObjectMapper> overrideObjectMapper = new ThreadLocal();
    private static ThreadLocal<ObjectMapper> overrideYamlObjectMapper = new ThreadLocal();

    public static ObjectMapper defaultObjectMapper() {
        return new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    public static ObjectMapper defaultYamlMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    private static ObjectMapper getObjectMapper() {
        return Optional.ofNullable(overrideObjectMapper.get()).orElse(DEFAULT_OBJECT_MAPPER);
    }

    private static ObjectMapper getYamlObjectMapper() {
        return Optional.ofNullable(overrideYamlObjectMapper.get()).orElse(DEFAULT_YAML_MAPPER);
    }

    public static void overrideObjectMapper(ObjectMapper mapper) {
        overrideObjectMapper.set(mapper);
    }

    public static void clearObjectMapperOverride() {
        overrideObjectMapper.remove();
    }

    public static void overrideYamlObjectMapper(ObjectMapper mapper) {
        overrideYamlObjectMapper.set(mapper);
    }

    public static void clearYamlObjectMapperOverride() {
        overrideYamlObjectMapper.remove();
    }

    public static JsonProvider<String> jsonStringProvider() {
        return arg_0 -> ((ObjectMapper)JsonProviders.getObjectMapper()).readTree(arg_0);
    }

    public static JsonProvider<Object> jsonObjectProvider() {
        return object -> (JsonNode)JsonProviders.getObjectMapper().convertValue(object, JsonNode.class);
    }

    public static JsonProvider<File> jsonFileProvider() {
        return arg_0 -> ((ObjectMapper)JsonProviders.getObjectMapper()).readTree(arg_0);
    }

    public static JsonProvider<Path> jsonPathProvider() {
        return path -> JsonProviders.getObjectMapper().readTree(path.toFile());
    }

    public static JsonProvider<String> yamlStringProvider() {
        return arg_0 -> ((ObjectMapper)JsonProviders.getYamlObjectMapper()).readTree(arg_0);
    }

    public static JsonProvider<File> yamlFileProvider() {
        return arg_0 -> ((ObjectMapper)JsonProviders.getYamlObjectMapper()).readTree(arg_0);
    }

    public static JsonProvider<Path> yamlPathProvider() {
        return path -> JsonProviders.getYamlObjectMapper().readTree(path.toFile());
    }
}

