/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.nio.file.Path;
import uk.org.webcompere.modelassert.json.JsonProviders;
import uk.org.webcompere.modelassert.json.assertjson.AssertJson;
import uk.org.webcompere.modelassert.json.hamcrest.HamcrestJsonAssertionBuilder;

public final class JsonAssertions {
    public static AssertJson<String> assertJson(String json) {
        return new AssertJson<String>(JsonProviders.jsonStringProvider(), json);
    }

    public static AssertJson<JsonNode> assertJson(JsonNode jsonNode) {
        return new AssertJson<JsonNode>(node -> node, jsonNode);
    }

    public static AssertJson<File> assertJson(File file) {
        return new AssertJson<File>(JsonProviders.jsonFileProvider(), file);
    }

    public static AssertJson<File> assertJson(Path path) {
        return JsonAssertions.assertJson(path.toFile());
    }

    public static AssertJson<Object> assertJson(Object object) {
        return new AssertJson<Object>(JsonProviders.jsonObjectProvider(), object);
    }

    public static HamcrestJsonAssertionBuilder<String> json() {
        return new HamcrestJsonAssertionBuilder<String>(JsonProviders.jsonStringProvider());
    }

    public static HamcrestJsonAssertionBuilder<Object> jsonObject() {
        return new HamcrestJsonAssertionBuilder<Object>(JsonProviders.jsonObjectProvider());
    }

    public static HamcrestJsonAssertionBuilder<JsonNode> jsonNode() {
        return new HamcrestJsonAssertionBuilder<JsonNode>(node -> node);
    }

    public static HamcrestJsonAssertionBuilder<File> jsonFile() {
        return new HamcrestJsonAssertionBuilder<File>(JsonProviders.jsonFileProvider());
    }

    public static HamcrestJsonAssertionBuilder<Path> jsonFilePath() {
        return new HamcrestJsonAssertionBuilder<Path>(JsonProviders.jsonPathProvider());
    }

    public static AssertJson<String> assertYaml(String yaml) {
        return new AssertJson<String>(JsonProviders.yamlStringProvider(), yaml);
    }

    public static AssertJson<File> assertYaml(File file) {
        return new AssertJson<File>(JsonProviders.yamlFileProvider(), file);
    }

    public static AssertJson<Path> assertYaml(Path path) {
        return new AssertJson<Path>(JsonProviders.yamlPathProvider(), path);
    }

    public static HamcrestJsonAssertionBuilder<String> yaml() {
        return new HamcrestJsonAssertionBuilder<String>(JsonProviders.yamlStringProvider());
    }

    public static HamcrestJsonAssertionBuilder<File> yamlFile() {
        return new HamcrestJsonAssertionBuilder<File>(JsonProviders.yamlFileProvider());
    }

    public static HamcrestJsonAssertionBuilder<Path> yamlFilePath() {
        return new HamcrestJsonAssertionBuilder<Path>(JsonProviders.yamlPathProvider());
    }
}

