/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific;

import com.fasterxml.jackson.databind.JsonNode;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.condition.ArrayContains;
import uk.org.webcompere.modelassert.json.condition.ConditionList;
import uk.org.webcompere.modelassert.json.condition.HasSize;
import uk.org.webcompere.modelassert.json.condition.Not;
import uk.org.webcompere.modelassert.json.condition.PredicateWrappedCondition;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.Sizeable;

public interface ArrayNodeDsl<A>
extends Satisfies<A>,
Sizeable<A> {
    default public A satisfiesArrayCondition(Condition condition) {
        return this.satisfies(new PredicateWrappedCondition("Array", JsonNode::isArray, condition));
    }

    default public A isArray() {
        return this.satisfies(new PredicateWrappedCondition("Object", JsonNode::isArray));
    }

    default public A isNotArray() {
        return this.satisfies(Not.not(new PredicateWrappedCondition("Object", JsonNode::isArray)));
    }

    default public A isArrayContaining(Object first, Object ... rest) {
        return this.satisfiesArrayCondition(ArrayContains.containsValues(first, rest));
    }

    default public A isArrayContaining(ConditionList conditions) {
        return this.satisfiesArrayCondition(ArrayContains.containsValues(conditions));
    }

    default public A isArrayContainingExactly(Object first, Object ... rest) {
        return this.satisfiesArrayCondition(ArrayContains.containsValuesExactly(first, rest));
    }

    default public A isArrayContainingExactly(ConditionList conditions) {
        return this.satisfiesArrayCondition(ArrayContains.containsValuesExactly(conditions));
    }

    default public A isArrayContainingExactlyInAnyOrder(Object first, Object ... rest) {
        return this.satisfiesArrayCondition(new HasSize(1 + rest.length).and(ArrayContains.containsValues(first, rest)));
    }

    default public A isArrayContainingExactlyInAnyOrder(ConditionList conditions) {
        return this.satisfiesArrayCondition(new HasSize(conditions.getConditionList().size()).and(ArrayContains.containsValues(conditions)));
    }
}

