/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.concurrent.ConcurrencySupport;

@ThreadSafe
public class XMLStreamParser<T extends XMLStreamParser>
extends ConcurrencySupport {
    private static final int DEFAULT_DEPTH = 2;
    private final Set<Listener<T>> listeners;
    private Listener<T>[] listenerCache;
    private final Map<String, String> nameSpaceMap;
    private final Document document;
    private Node node;
    private final int triggerDepth;
    private int depth;
    private boolean triggerRootNode = false;
    private int appendDepth = 1;

    public XMLStreamParser(Document document) throws ParserConfigurationException, IllegalArgumentException, XMLStreamException, FactoryConfigurationError {
        this(2, document);
    }

    public XMLStreamParser(int depth, Document document) throws ParserConfigurationException, IllegalArgumentException, XMLStreamException, FactoryConfigurationError {
        this.triggerDepth = depth;
        this.appendDepth = Math.max(this.appendDepth, this.triggerDepth - 1);
        this.document = document;
        this.nameSpaceMap = new HashMap<String, String>();
        this.listeners = new HashSet<Listener<T>>();
        this.updateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public boolean isTriggerRootNode() {
        this.readLock().lock();
        try {
            boolean bl = this.triggerRootNode;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setTriggerRootNode(boolean triggerRootNode) {
        this.writeLock().lock();
        try {
            this.triggerRootNode = triggerRootNode;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public boolean addListener(Listener<T> l) {
        this.writeLock().lock();
        try {
            try {
                boolean bl = this.listeners.add(l);
                this.updateCache();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateCache();
                throw throwable;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public boolean removeListener(Listener<T> l) {
        this.writeLock().lock();
        try {
            try {
                boolean bl = this.listeners.remove(l);
                this.updateCache();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateCache();
                throw throwable;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void removeAllListeners() {
        this.writeLock().lock();
        try {
            try {
                this.listeners.clear();
            }
            finally {
                this.updateCache();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void updateCache() {
        this.listenerCache = this.listeners.toArray(new Listener[this.listeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public Listener<T>[] listeners() {
        this.readLock().lock();
        try {
            Listener<T>[] listenerArray = this.listenerCache;
            return listenerArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameSpaceSubstitution(String orig, String newValue) {
        this.writeLock().lock();
        try {
            this.nameSpaceMap.put(orig, newValue);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public int getAppendDepth() {
        this.readLock().lock();
        try {
            int n = this.appendDepth;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setAppendDepth(int appendDepth) {
        this.writeLock().lock();
        try {
            if (appendDepth < 1) {
                throw new IllegalArgumentException("appendDepth must be >= 1");
            }
            this.appendDepth = appendDepth;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void processEvents(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (xmlStreamReader.hasNext()) {
            switch (xmlStreamReader.next()) {
                case 1: {
                    String ns;
                    ++this.depth;
                    Element e = null;
                    e = xmlStreamReader.getNamespaceURI() == null ? this.document.createElement(xmlStreamReader.getLocalName()) : this.document.createElementNS((ns = this.nameSpaceMap.get(xmlStreamReader.getNamespaceURI())) == null ? xmlStreamReader.getNamespaceURI() : ns, xmlStreamReader.getLocalName());
                    e.setPrefix(xmlStreamReader.getPrefix());
                    for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        e.setAttributeNS(xmlStreamReader.getAttributeNamespace(i), xmlStreamReader.getAttributeLocalName(i), xmlStreamReader.getAttributeValue(i));
                    }
                    if (this.depth > this.appendDepth) {
                        this.node.appendChild(e);
                    }
                    this.node = e;
                    if (!this.triggerRootNode || this.depth != 1 || this.triggerDepth <= 1) break;
                    this.notifyNode(this.node);
                    break;
                }
                case 2: {
                    if (this.depth == this.triggerDepth) {
                        this.notifyNode(this.node);
                    } else {
                        this.node = this.node.getParentNode();
                    }
                    --this.depth;
                    break;
                }
                case 4: {
                    this.node.appendChild(this.document.createTextNode(xmlStreamReader.getText()));
                    break;
                }
            }
        }
    }

    protected final void notifyNode(Node node) {
        for (Listener<XMLStreamParser> listener : this.listeners()) {
            listener.STaXThreadNodeReceived(this, node);
        }
    }

    public final void notifyStreamClosed() {
        for (Listener<XMLStreamParser> listener : this.listeners()) {
            listener.STaXThreadClosed(this);
        }
    }

    public final void notifyStreamError(Exception ex) {
        for (Listener<XMLStreamParser> listener : this.listeners()) {
            listener.STaXThreadError(this, ex);
        }
    }

    public static interface Listener<T extends XMLStreamParser> {
        public void STaXThreadClosed(T var1);

        public void STaXThreadError(T var1, Exception var2);

        public void STaXThreadNodeReceived(T var1, Node var2);
    }
}

