/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.File;
import java.io.IOException;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.AbstractFileVisitor;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.io.tar.TarEntry;
import uk.org.retep.util.io.tar.TarHeader;
import uk.org.retep.util.io.tar.TarOutputStream;
import uk.org.retep.util.string.StringUtils;

public class TarFileVisitor
extends AbstractFileVisitor {
    private final TarOutputStream tos;
    private String baseDir;
    private String dirPrefix;

    public TarFileVisitor(TarOutputStream tos) {
        this((Log)null, tos);
    }

    public TarFileVisitor(Log log, TarOutputStream tos) {
        this(log, "Added %s to tar", tos);
    }

    public TarFileVisitor(Log log, String message, TarOutputStream tos) {
        super(log, message);
        this.tos = tos;
    }

    public TarFileVisitor(TarOutputStream tos, File baseDir) throws IOException {
        this((Log)null, tos);
        this.setBaseDir(baseDir);
    }

    public TarFileVisitor(Log log, TarOutputStream tos, File baseDir) throws IOException {
        this(log, tos);
        this.setBaseDir(baseDir);
    }

    public TarFileVisitor(Log log, String message, TarOutputStream tos, File baseDir) throws IOException {
        this(log, message, tos);
        this.setBaseDir(baseDir);
    }

    public void setDirPrefix(String dirPrefix) {
        this.dirPrefix = dirPrefix == null || dirPrefix.endsWith("/") ? dirPrefix : dirPrefix + "/";
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir == null ? "" : baseDir;
    }

    public void setBaseDir(File baseDir) throws IOException {
        this.baseDir = baseDir == null ? "" : baseDir.getCanonicalPath();
    }

    @Override
    protected boolean execute(final File file) throws IOException {
        String name = file.getCanonicalPath();
        name = this.baseDir != null && name.startsWith(this.baseDir) ? name.substring(this.baseDir.length() + 1) : file.getName();
        if (StringUtils.isStringNotEmpty(this.dirPrefix)) {
            name = this.dirPrefix + name;
        }
        TarEntry te = new TarEntry(new File(name){

            @Override
            public boolean isDirectory() {
                return file.isDirectory();
            }
        });
        te.setModTime(file.lastModified());
        te.setGNUTarFormat();
        if (file.isFile()) {
            TarHeader hdr = te.getHeader();
            if (hdr != null) {
                hdr.mode = 32768;
                if (file.canRead()) {
                    hdr.mode |= 0x124;
                }
                if (file.canWrite()) {
                    hdr.mode |= 0x80;
                }
                if (file.canExecute()) {
                    hdr.mode |= 0x49;
                }
            }
            te.setSize(file.length());
            this.tos.putNextEntry(te);
            FileUtils.copyFile(file, this.tos);
            this.tos.closeEntry();
        } else {
            this.tos.putNextEntry(te);
            this.tos.closeEntry();
        }
        return true;
    }
}

