/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml.jaxb;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import uk.org.retep.util.services.Service;

public abstract class JAXBPluginLibrary
extends Plugin {
    private Set<String> namespaces = new HashSet<String>();
    private Set<Plugin> plugins = new HashSet<Plugin>();
    private Map<String, List<Plugin>> pluginMap = new HashMap<String, List<Plugin>>();

    public JAXBPluginLibrary() {
        for (Class<?> clazz : Service.providerClasses(((Object)((Object)this)).getClass())) {
            try {
                this.registerPlugin((Plugin)clazz.newInstance());
            }
            catch (Exception exception) {}
        }
    }

    protected final void registerPlugin(Plugin plugin) {
        if (this.plugins.add(plugin)) {
            for (String namespace : plugin.getCustomizationURIs()) {
                this.namespaces.add(namespace);
                List<Plugin> l = this.pluginMap.get(namespace);
                if (l == null) {
                    l = new ArrayList<Plugin>();
                    this.pluginMap.put(namespace, l);
                }
                l.add(plugin);
            }
        }
    }

    public final List<String> getCustomizationURIs() {
        return new ArrayList<String>(this.namespaces);
    }

    public final boolean isCustomizationTagName(String nsUri, String localName) {
        List<Plugin> l = this.pluginMap.get(nsUri);
        if (l == null) {
            return false;
        }
        for (Plugin plugin : l) {
            if (!plugin.isCustomizationTagName(nsUri, localName)) continue;
            return true;
        }
        return false;
    }

    public final void onActivated(Options opts) throws BadCommandLineException {
        for (Plugin plugin : this.plugins) {
            plugin.onActivated(opts);
        }
    }

    public final int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int c = 0;
        for (Plugin plugin : this.plugins) {
            c += plugin.parseArgument(opt, args, i);
        }
        return c;
    }

    public final void postProcessModel(Model model, ErrorHandler errorHandler) {
        for (Plugin plugin : this.plugins) {
            plugin.postProcessModel(model, errorHandler);
        }
    }

    public final String getUsage() {
        StringBuilder sb = new StringBuilder();
        this.getUseage(sb);
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        for (Plugin plugin : this.plugins) {
            String useage = plugin.getUsage();
            if (useage == null) continue;
            sb.append(useage).append('\n');
        }
        return sb.toString();
    }

    protected abstract void getUseage(StringBuilder var1);

    public final boolean run(Outline model, Options opt, ErrorHandler errorHandler) throws SAXException {
        boolean ret = false;
        for (Plugin plugin : this.plugins) {
            ret |= plugin.run(model, opt, errorHandler);
        }
        return ret;
    }
}

