/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.unit;

public enum AngleUnit {
    ANGULAR_MIL{

        @Override
        public double convert(double a, AngleUnit u) {
            return u.toAngularMil(a);
        }

        @Override
        public double toRadian(double a) {
            return Math.PI * a / 3200.0;
        }

        @Override
        public double toDegree(double a) {
            return 9.0 * a * Math.PI / 502.6548245743669;
        }

        @Override
        public double toMinuteOfArc(double a) {
            return 27.0 * a * Math.PI / (Math.PI * 8);
        }

        @Override
        public double toArcSecond(double a) {
            return 405.0 * a * Math.PI / (Math.PI * 2);
        }

        @Override
        public double toGradian(double a) {
            return a;
        }

        @Override
        public double toAngularMil(double a) {
            return a / 16.0;
        }

        @Override
        public String getName() {
            return "angular mil";
        }

        @Override
        public String unitString() {
            return "\u00b5";
        }

        @Override
        public char unitChar() {
            return '\u00b5';
        }
    }
    ,
    ARC_SECOND{

        @Override
        public double convert(double a, AngleUnit u) {
            return u.toArcSecond(a);
        }

        @Override
        public double toRadian(double a) {
            return a * Math.PI / 648000.0;
        }

        @Override
        public double toDegree(double a) {
            return a / 3600.0;
        }

        @Override
        public double toMinuteOfArc(double a) {
            return a / 60.0;
        }

        @Override
        public double toArcSecond(double a) {
            return a;
        }

        @Override
        public double toGradian(double a) {
            return a / 3240.0;
        }

        @Override
        public double toAngularMil(double a) {
            return a / 51840.0;
        }

        @Override
        public String getName() {
            return "arc second";
        }

        @Override
        public String unitString() {
            return "\"";
        }

        @Override
        public char unitChar() {
            return '\u2033';
        }
    }
    ,
    DEGREE{

        @Override
        public double convert(double a, AngleUnit u) {
            return u.toDegree(a);
        }

        @Override
        public double toRadian(double a) {
            return a * Math.PI / 180.0;
        }

        @Override
        public double toDegree(double a) {
            return a;
        }

        @Override
        public double toMinuteOfArc(double a) {
            return a * 60.0;
        }

        @Override
        public double toArcSecond(double a) {
            return a * 3600.0;
        }

        @Override
        public double toGradian(double a) {
            return 10.0 * a / 9.0;
        }

        @Override
        public double toAngularMil(double a) {
            return 160.0 * a / 9.0;
        }

        @Override
        public String getName() {
            return "degree (of arc)";
        }

        @Override
        public String unitString() {
            return "\u00b0";
        }

        @Override
        public char unitChar() {
            return '\u00b0';
        }

        @Override
        public String unicodeString() {
            return "\u00b0";
        }
    }
    ,
    GRADIAN{

        @Override
        public double convert(double a, AngleUnit u) {
            return u.toGradian(a);
        }

        @Override
        public double toRadian(double a) {
            return Math.PI * a / 200.0;
        }

        @Override
        public double toDegree(double a) {
            return 9.0 * a / 10.0;
        }

        @Override
        public double toMinuteOfArc(double a) {
            return 54.0 * a;
        }

        @Override
        public double toArcSecond(double a) {
            return 3240.0 * a;
        }

        @Override
        public double toGradian(double a) {
            return a;
        }

        @Override
        public double toAngularMil(double a) {
            return a / 16.0;
        }

        @Override
        public String getName() {
            return "gradian";
        }

        @Override
        public String unitString() {
            return "gr";
        }

        @Override
        public char unitChar() {
            return '?';
        }
    }
    ,
    MINUTE_OF_ARC{

        @Override
        public double convert(double a, AngleUnit u) {
            return u.toMinuteOfArc(a);
        }

        @Override
        public double toRadian(double a) {
            return 2.908882086657216E-4;
        }

        @Override
        public double toDegree(double a) {
            return a / 60.0;
        }

        @Override
        public double toMinuteOfArc(double a) {
            return a;
        }

        @Override
        public double toArcSecond(double a) {
            return a * 60.0;
        }

        @Override
        public double toGradian(double a) {
            return a / 54.0;
        }

        @Override
        public double toAngularMil(double a) {
            return 8.0 * a / 27.0;
        }

        @Override
        public String getName() {
            return "minutes of arc";
        }

        @Override
        public String unitString() {
            return "'";
        }

        @Override
        public char unitChar() {
            return '\u2032';
        }

        @Override
        public String unicodeString() {
            return "\u2032";
        }
    }
    ,
    RADIAN{

        @Override
        public double convert(double a, AngleUnit u) {
            return u.toRadian(a);
        }

        @Override
        public double toRadian(double a) {
            return a;
        }

        @Override
        public double toDegree(double a) {
            return 180.0 * a / Math.PI;
        }

        @Override
        public double toMinuteOfArc(double a) {
            return 10800.0 * a / Math.PI;
        }

        @Override
        public double toArcSecond(double a) {
            return 648000.0 * a / Math.PI;
        }

        @Override
        public double toGradian(double a) {
            return a * Math.PI / 200.0;
        }

        @Override
        public double toAngularMil(double a) {
            return a * Math.PI / 3200.0;
        }

        @Override
        public String getName() {
            return "radian";
        }

        @Override
        public String unitString() {
            return "rad";
        }

        @Override
        public char unitChar() {
            return '?';
        }
    };

    public static final char UNICODE_UNSUPPORTED = '?';

    public double convert(double sourceAngle, AngleUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public double toArcSecond(double a) {
        throw new AbstractMethodError();
    }

    public double toDegree(double a) {
        throw new AbstractMethodError();
    }

    public double toGradian(double a) {
        throw new AbstractMethodError();
    }

    public double toAngularMil(double a) {
        throw new AbstractMethodError();
    }

    public double toMinuteOfArc(double a) {
        throw new AbstractMethodError();
    }

    public double toRadian(double a) {
        throw new AbstractMethodError();
    }

    public String getName() {
        throw new AbstractMethodError();
    }

    public String unitString() {
        throw new AbstractMethodError();
    }

    public char unitChar() {
        return '?';
    }

    public String unicodeString() {
        return String.valueOf('?');
    }

    public final String toString(double t) {
        return AngleUnit.toString(t, this);
    }

    public static final String toString(double t, AngleUnit unit) {
        return String.format("%.2f%s", t, unit.unitString());
    }

    public final String toUnicodeString(double t) {
        return AngleUnit.toUnicodeString(t, this);
    }

    public static final String toUnicodeString(double t, AngleUnit unit) {
        if (unit.unitChar() == '?') {
            return AngleUnit.toString(t, unit);
        }
        return String.format("%.2f%c", t, Character.valueOf(unit.unitChar()));
    }
}

