/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import uk.org.retep.util.io.lzma.Encoder;
import uk.org.retep.util.monitor.ProgressListener;
import uk.org.retep.util.thread.ExecutorFactory;

public class LzmaOutputStream
extends OutputStream {
    public static final int ALGORITHM = 2;
    public static final int DICTIONARY_SIZE = 0x200000;
    public static final int MATCH_FINDER = 1;
    public static final int FB = 128;
    public static final int LC = 3;
    public static final int LP = 0;
    public static final int PB = 2;
    private final OutputStream outputStream;
    private final PipedInputStream pipeIn;
    private final PipedOutputStream pipeOut;
    private ProgressListener listener;
    private Encoder encoder;

    public LzmaOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, null);
    }

    public LzmaOutputStream(OutputStream outputStream, ProgressListener listener) throws IOException {
        this(outputStream, listener, -1L);
    }

    public LzmaOutputStream(OutputStream outputStream, long streamSize) throws IOException {
        this(outputStream, null, streamSize);
    }

    public LzmaOutputStream(OutputStream outputStream, ProgressListener listener, long streamSize) throws IOException {
        this(outputStream, listener, streamSize, 2, 0x200000, 1, 128, 3, 0, 2);
    }

    public LzmaOutputStream(final OutputStream outputStream, final ProgressListener listener, long streamSize, int algorithm, int dictionarySize, int matchFinder, int fb, int lc, int lp, int pb) throws IOException {
        if (streamSize < -1L) {
            throw new IllegalArgumentException("streamSize is either -1 or a positive value");
        }
        this.outputStream = outputStream;
        this.listener = listener;
        this.pipeIn = new PipedInputStream();
        this.pipeOut = new PipedOutputStream(this.pipeIn);
        this.encoder = new Encoder();
        if (!this.encoder.setAlgorithm(algorithm)) {
            throw new IOException("Incorrect compression mode");
        }
        if (!this.encoder.setDictionarySize(dictionarySize)) {
            throw new IOException("Incorrect dictionary size");
        }
        if (!this.encoder.setNumFastBytes(fb)) {
            throw new IOException("Incorrect fb value");
        }
        if (!this.encoder.setMatchFinder(matchFinder)) {
            throw new IOException("Incorrect-mf value");
        }
        if (!this.encoder.setLcLpPb(lc, lp, pb)) {
            throw new IOException("Incorrect lc or lp or pb value");
        }
        this.encoder.setEndMarkerMode(streamSize > -1L);
        this.encoder.writeCoderProperties(outputStream);
        for (int i = 0; i < 8; ++i) {
            outputStream.write((int)(streamSize >>> 8 * i) & 0xFF);
        }
        if (listener != null && streamSize > -1L) {
            listener.setMaximum(streamSize, streamSize);
        }
        ExecutorFactory.globalInvokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LzmaOutputStream.this.encoder.code(LzmaOutputStream.this.pipeIn, outputStream, -1L, -1L, listener);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    LzmaOutputStream.this.pipeOut.flush();
                    LzmaOutputStream.this.pipeOut.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.pipeIn.close();
            this.pipeOut.close();
        }
        finally {
            this.outputStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.pipeOut.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.pipeOut.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.pipeOut.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.pipeOut.write(b, off, len);
    }
}

