/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import uk.org.retep.util.io.ComplexFile;

public class SimpleComplexFile
implements ComplexFile,
Comparable<ComplexFile> {
    protected File sourceFile;
    protected File destinationFile;

    public SimpleComplexFile(File file) {
        this(file, file);
    }

    public SimpleComplexFile(File sourceFile, File destinationFile) {
        if (sourceFile == null) {
            throw new NullPointerException("sourceFile may not be null");
        }
        this.sourceFile = sourceFile;
        if (destinationFile == null) {
            throw new NullPointerException("destinationFile may not be null");
        }
        if (destinationFile.isAbsolute()) {
            throw new IllegalArgumentException("destinationFile may not be absolute");
        }
        this.destinationFile = destinationFile;
    }

    @Override
    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public File getDestinationFile() {
        return this.destinationFile;
    }

    @Override
    public int compareTo(ComplexFile file) {
        return this.getDestinationFile().compareTo(file.getDestinationFile());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ComplexFile)) {
            return false;
        }
        return this.getDestinationFile().equals(((ComplexFile)ComplexFile.class.cast(obj)).getDestinationFile());
    }

    public int hashCode() {
        return this.getDestinationFile().hashCode();
    }

    public String toString() {
        return this.getDestinationFile().toString();
    }
}

