/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.org.retep.util.io.BufferedCharReader;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.string.StringUtils;

public final class MapUtils {
    private MapUtils() {
    }

    public static Map<String, String> loadMap(Map<String, String> map, URL url) throws IOException {
        return MapUtils.loadMap(map, url.openStream());
    }

    public static Map<String, String> loadMap(Map<String, String> map, InputStream is) throws IOException {
        return MapUtils.loadMap(map, new InputStreamReader(is));
    }

    public static Map<String, String> loadMap(Map<String, String> map, Reader reader) throws IOException {
        BufferedReader rdr = new BufferedReader(reader);
        boolean run = true;
        while (run) {
            String line = rdr.readLine();
            if (line == null) {
                run = false;
                continue;
            }
            if (line.equals("") || line.startsWith("#")) continue;
            int start = StringUtils.findNonWhitespace(line);
            int sep = StringUtils.findKeySeparator(line, start);
            String key = line.substring(start, sep);
            String val = line.substring(StringUtils.findKeyValue(line, sep));
            map.put(key, val);
        }
        return map;
    }

    public static Map<String, String> loadMap(InputStream is, Map<String, String> map) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(is), map);
    }

    public static Map<String, String> loadMap(InputStream is) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(is));
    }

    public static Map<String, String> loadMap(Reader r, Map<String, String> map) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(r), map);
    }

    public static Map<String, String> loadMap(Reader r) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(r));
    }

    public static Map<String, String> loadMap(File file, Map<String, String> map) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(file), map);
    }

    public static Map<String, String> loadMap(File file) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(file));
    }

    public static Map<String, String> loadMap(BufferedCharReader r, Map<String, String> map) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(r), map);
    }

    public static Map<String, String> loadMap(BufferedCharReader r) throws IOException {
        return MapUtils.loadMap(FileUtils.readLines(r));
    }

    public static Map<String, String> loadMap(List<String> lines) {
        return MapUtils.loadMap(lines, new HashMap<String, String>());
    }

    public static Map<String, String> loadMap(List<String> lines, Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            int l = line.length() - 1;
            if (l < 0) continue;
            int c = -1;
            if (line.length() > 0) {
                int h = line.indexOf(35);
                while (h > 0 && h < l && line.charAt(h - 1) == '\\') {
                    h = line.indexOf(35, h + 1);
                }
                int p = line.indexOf(33);
                while (p > 0 && p < l && line.charAt(p - 1) == '\\') {
                    p = line.indexOf(33, p + 1);
                }
                if (h > -1) {
                    c = h;
                }
                if (p > -1 && p < h) {
                    c = p;
                }
            }
            if (c == 0) continue;
            if (c > 0) {
                line = line.substring(0, c);
            }
            if (line.charAt(line.length() - 1) == '\'') {
                sb.append(line);
                sb.setLength(sb.length() - 1);
                continue;
            }
            if (sb.length() == 0) {
                MapUtils.loadLine(line, map);
                continue;
            }
            sb.append(line);
            MapUtils.loadLine(sb.toString(), map);
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            MapUtils.loadLine(sb.toString(), map);
        }
        return map;
    }

    public static Map<String, String> loadLine(String line, Map<String, String> map) {
        boolean isDelim;
        if (line == null) {
            return map;
        }
        char[] b = line.trim().toCharArray();
        if (b.length == 0 || b[0] == '#' || b[0] == '!') {
            return map;
        }
        StringBuffer key = new StringBuffer();
        int pos = 0;
        char c = '\u0000';
        block12: while (pos < line.length() && !Character.isWhitespace(c = b[pos++]) && c != '=' && c != ':') {
            if (c == '\'') {
                c = line.charAt(pos++);
                switch (c) {
                    case 'n': {
                        key.append('\n');
                        continue block12;
                    }
                    case 't': {
                        key.append('\t');
                        continue block12;
                    }
                    case 'r': {
                        key.append('\r');
                        continue block12;
                    }
                    case 'u': {
                        if (pos + 4 > line.length()) continue block12;
                        char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                        key.append(uni);
                        pos += 4;
                        continue block12;
                    }
                }
                key.append(c);
                continue;
            }
            key.append(c);
        }
        boolean bl = isDelim = c == ':' || c == '=';
        while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
            ++pos;
        }
        if (!(isDelim || c != ':' && c != '=')) {
            ++pos;
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
        }
        StringBuilder value = new StringBuilder(line.length() - pos);
        block15: while (pos < line.length()) {
            if ((c = line.charAt(pos++)) == '\\') {
                c = line.charAt(pos++);
                switch (c) {
                    case 'n': {
                        value.append('\n');
                        continue block15;
                    }
                    case 't': {
                        value.append('\t');
                        continue block15;
                    }
                    case 'r': {
                        value.append('\r');
                        continue block15;
                    }
                    case 'u': {
                        if (pos + 4 > line.length()) continue block15;
                        char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                        value.append(uni);
                        pos += 4;
                        continue block15;
                    }
                }
                value.append(c);
                continue;
            }
            value.append(c);
        }
        map.put(key.toString(), value.toString());
        return map;
    }
}

