/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.retep.util.tree.StringTree;

public class PropertySet
implements Set<Property> {
    private String label;
    private final List<Property> properties;

    public PropertySet() {
        this.label = "";
        this.properties = new ArrayList<Property>();
    }

    public PropertySet(String text) {
        this.properties = new ArrayList<Property>();
        this.setText(text);
    }

    public void setText(String text) {
        Pattern pat = Pattern.compile("(\\[(.*?)\\])");
        Matcher mat = pat.matcher(text);
        StringBuffer sb = new StringBuffer();
        this.properties.clear();
        while (mat.find()) {
            this.properties.add(new Property(mat.group(2)));
            mat.appendReplacement(sb, "");
        }
        this.label = StringTree.trimWhitespace(mat.appendTail(sb).toString());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Collection<Property> getProperties() {
        return this.properties;
    }

    public String getStyle(String name) {
        for (Property p : this.properties) {
            if (!p.isStyle() || !name.equals(p.getStyleName())) continue;
            return p.getStyleValue();
        }
        return null;
    }

    public String getStyle(String name, String defaultValue) {
        String v = this.getStyle(name);
        return v == null ? defaultValue : v;
    }

    public boolean removeStyle(String name) {
        for (Property p : this.properties) {
            if (!p.isStyle() || !name.equals(p.getStyleName())) continue;
            this.remove(p);
            return true;
        }
        return false;
    }

    public void setStyle(String name, String value) {
        for (Property p : this.properties) {
            if (!p.isStyle() || !name.equals(p.getStyleName())) continue;
            p.setStyle(name, value);
            return;
        }
        this.add(new Property(name, value));
    }

    public boolean hasStyle(String name) {
        return this.getStyle(name) != null;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public StringBuilder append(StringBuilder sb) {
        sb.append(this.label).append(' ');
        PropertySet.appendProperties(sb, this.properties);
        return sb;
    }

    public static final StringBuilder appendProperties(StringBuilder sb, Collection<? extends Property> col) {
        for (Property property : col) {
            sb.append('[').append(property).append(']');
        }
        return sb;
    }

    @Override
    public int hashCode() {
        return this.label.hashCode() * 31 + ((Object)this.properties).hashCode();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.label.length() <= 0 && this.properties.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.properties.contains(o);
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.properties.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.properties.toArray(a);
    }

    @Override
    public boolean add(Property o) {
        return this.properties.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.properties.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.properties.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Property> c) {
        return this.properties.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.properties.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.properties.removeAll(c);
    }

    @Override
    public void clear() {
        this.label = "";
        this.properties.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PropertySet) {
            PropertySet p = (PropertySet)o;
            return this.label.equals(p.label) && ((Object)this.properties).equals(p.properties);
        }
        return false;
    }

    public static class Property {
        private String text;

        public Property() {
            this.text = "";
        }

        public Property(String text) {
            this.setText(text);
        }

        public Property(String name, String value) {
            this.setStyle(name, value);
        }

        public boolean isPlain() {
            return !this.isStyle();
        }

        public boolean isStyle() {
            if (this.text.length() < 3 || this.text.charAt(0) != ':') {
                return false;
            }
            int i = this.text.indexOf(58, 2);
            return i > -1 && i + 1 < this.text.length();
        }

        public String getStyleName() {
            String name = null;
            if (this.isStyle()) {
                int i = this.text.indexOf(58, 2);
                return this.text.substring(1, i);
            }
            return name;
        }

        public String getStyleValue() {
            String value = null;
            if (this.isStyle()) {
                int i = this.text.indexOf(58, 2);
                return this.text.substring(i + 1);
            }
            return value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = StringTree.trimWhitespace(text);
        }

        public void setStyle(String name, String value) {
            this.setText(":" + name + ":" + value);
        }

        public String toString() {
            return this.getText();
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

