/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.signal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import uk.org.retep.util.signal.SignalHandler;

public class Signal {
    private static final String UNSUPPORTED = "Signals not supported by this platform or JVM";
    private static final String SIGNAL_CLASS = "sun.misc.Signal";
    private static final String SIGNAL_HANDLER_CLASS = "sun.misc.SignalHandler";
    private static Class signalClass;
    private static Class signalHandlerClass;
    private static Constructor signalConstructor;
    private static Method signalHandle;
    private static Method getName;
    private static final Lock lock;
    private static final Map<String, Signal> signalNames;
    private static final Map<Signal, Set<SignalHandler>> handlers;
    private final String name;
    private final Object signal;

    private Signal(String name) {
        this.name = name;
        if (signalClass == null) {
            Signal.init();
        }
        try {
            this.signal = signalConstructor.newInstance(name);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IllegalArgumentException(UNSUPPORTED, ite);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(UNSUPPORTED, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Signal getSignal(String name) {
        lock.lock();
        try {
            Signal signal = signalNames.get(name);
            if (signal == null) {
                signal = new Signal(name);
                signalNames.put(name, signal);
            }
            Signal signal2 = signal;
            return signal2;
        }
        finally {
            lock.unlock();
        }
    }

    private static synchronized void init() throws IllegalArgumentException {
        if (signalClass == null) {
            try {
                signalClass = Class.forName(SIGNAL_CLASS);
                signalHandlerClass = Class.forName(SIGNAL_HANDLER_CLASS);
                signalConstructor = signalClass.getConstructor(String.class);
                signalHandle = signalClass.getMethod("handle", signalClass, signalHandlerClass);
                getName = signalClass.getMethod("getName", new Class[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(UNSUPPORTED);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof Signal)) {
            return false;
        }
        return this.name.equals(((Signal)Signal.class.cast((Object)other)).name);
    }

    public static void registerSignalHandler(Signal signal, SignalHandler handler) throws IllegalArgumentException {
        lock.lock();
        try {
            Set<SignalHandler> signals = handlers.get(signal);
            if (signals == null) {
                Signal.registerWithJVM(signal);
                signals = new LinkedHashSet<SignalHandler>();
                handlers.put(signal, signals);
            }
            signals.add(handler);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        finally {
            lock.unlock();
        }
    }

    private static void registerWithJVM(Signal signal) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (signalClass == null) {
            Signal.init();
        }
        Object proxyHandler = Proxy.newProxyInstance(signalClass.getClassLoader(), new Class[]{signalHandlerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                String name = (String)getName.invoke(arg2[0], new Object[0]);
                Signal.invokeSignalHandlers(Signal.getSignal(name));
                return null;
            }
        });
        signalHandle.invoke(null, signal.signal, proxyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterSignalHandler(Signal signal, SignalHandler handler) {
        lock.lock();
        try {
            Set<SignalHandler> signals = handlers.get(signal);
            if (signals != null) {
                boolean bl = signals.remove(handler);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeSignalHandlers(Signal signal) {
        SignalHandler[] signals = null;
        lock.lock();
        try {
            Set<SignalHandler> set = handlers.get(signal);
            if (set != null) {
                signals = set.toArray(new SignalHandler[set.size()]);
            }
        }
        finally {
            lock.unlock();
        }
        for (SignalHandler handler : signals) {
            try {
                handler.handleSignal(signal);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    static {
        lock = new ReentrantLock();
        signalNames = new HashMap<String, Signal>();
        handlers = new HashMap<Signal, Set<SignalHandler>>();
    }
}

