/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import uk.org.retep.annotations.Unstable;

@Unstable
public class SynchronousResult<T> {
    private volatile T value;
    private Semaphore semaphore = new Semaphore(0);

    public T get() throws InterruptedException {
        this.semaphore.acquire();
        return this.value;
    }

    public T get(long delay, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.semaphore.tryAcquire(delay, unit)) {
            return this.value;
        }
        throw new TimeoutException();
    }

    public void put(T value) {
        this.value = value;
        this.semaphore.release();
    }
}

