/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.random;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Service;
import uk.org.retep.util.random.RandomSeedGenerator;

@ThreadSafe
public abstract class URLSeedGenerator
implements RandomSeedGenerator {
    public static final int CACHE_SIZE = 1024;
    protected final Lock lock = new ReentrantLock();
    private final String url;
    protected final int cacheSize;
    protected final byte[] cache;
    protected int cacheOffset;

    public URLSeedGenerator(String url) {
        this(url, 1024);
    }

    public URLSeedGenerator(String url, int cacheSize) {
        this.url = url;
        this.cacheSize = cacheSize;
        this.cache = new byte[cacheSize];
        this.cacheOffset = cacheSize;
    }

    protected final String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] generateSeed(int seedLength) {
        this.lock.lock();
        try {
            if (this.cacheOffset + seedLength >= this.cacheSize) {
                try {
                    this.refreshCache();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Unable to refresh cache", ioe);
                }
            }
            byte[] seed = new byte[seedLength];
            System.arraycopy(this.cache, this.cacheOffset, seed, 0, seedLength);
            this.cacheOffset += seedLength;
            byte[] byArray = seed;
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshCache() throws IOException {
        URLConnection connection = new URL(this.getURL()).openConnection();
        InputStream is = connection.getInputStream();
        try {
            this.refreshCache(is);
        }
        finally {
            is.close();
        }
        this.cacheOffset = 0;
    }

    protected abstract void refreshCache(InputStream var1) throws IOException;

    @ThreadSafe
    @Service(value=RandomSeedGenerator.class)
    public static class RandomOrgSeedGenerator
    extends URLSeedGenerator {
        public RandomOrgSeedGenerator() {
            super("http://www.random.org/cgi-bin/randbyte?nbytes=1024&format=d");
        }

        @Override
        public final String getName() {
            return "random.org";
        }

        @Override
        public int getPriority() {
            return 50;
        }

        @Override
        protected void refreshCache(InputStream is) throws IOException {
            StreamTokenizer tokenizer = new StreamTokenizer(new InputStreamReader(is));
            int index = -1;
            while (tokenizer.nextToken() != -1) {
                assert (tokenizer.ttype == -2) : "Invalid data received, expecting number";
                this.cache[++index] = (byte)tokenizer.nval;
            }
            assert (index == this.cacheSize - 1) : "Insufficient data received";
            this.cacheOffset = 0;
        }
    }
}

