/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import uk.org.retep.util.io.lzma.RangeDecoder;
import uk.org.retep.util.io.lzma.RangeEncoder;

class BitTreeEncoder {
    private short[] models;
    private int numBitLevels;

    public BitTreeEncoder(int numBitLevels) {
        this.numBitLevels = numBitLevels;
        this.models = new short[1 << numBitLevels];
    }

    public void init() {
        RangeDecoder.initBitModels(this.models);
    }

    public void encode(RangeEncoder rangeEncoder, int symbol) throws IOException {
        int m = 1;
        int bitIndex = this.numBitLevels;
        while (bitIndex != 0) {
            int bit = symbol >>> --bitIndex & 1;
            rangeEncoder.encode(this.models, m, bit);
            m = m << 1 | bit;
        }
    }

    public void reverseEncode(RangeEncoder rangeEncoder, int symbol) throws IOException {
        int m = 1;
        int sym = symbol;
        for (int i = 0; i < this.numBitLevels; ++i) {
            int bit = sym & 1;
            rangeEncoder.encode(this.models, m, bit);
            m = m << 1 | bit;
            sym >>= 1;
        }
    }

    public int getPrice(int symbol) {
        int price = 0;
        int m = 1;
        int bitIndex = this.numBitLevels;
        while (bitIndex != 0) {
            int bit = symbol >>> --bitIndex & 1;
            price += RangeEncoder.getPrice(this.models[m], bit);
            m = (m << 1) + bit;
        }
        return price;
    }

    public int reverseGetPrice(int symbol) {
        int price = 0;
        int m = 1;
        int sym = symbol;
        for (int i = this.numBitLevels; i != 0; --i) {
            int bit = sym & 1;
            sym >>>= 1;
            price += RangeEncoder.getPrice(this.models[m], bit);
            m = m << 1 | bit;
        }
        return price;
    }

    public static int reverseGetPrice(short[] Models, int startIndex, int NumBitLevels, int symbol) {
        int price = 0;
        int m = 1;
        int sym = symbol;
        for (int i = NumBitLevels; i != 0; --i) {
            int bit = sym & 1;
            sym >>>= 1;
            price += RangeEncoder.getPrice(Models[startIndex + m], bit);
            m = m << 1 | bit;
        }
        return price;
    }

    public static void reverseEncode(short[] Models, int startIndex, RangeEncoder rangeEncoder, int NumBitLevels, int symbol) throws IOException {
        int m = 1;
        int sym = symbol;
        for (int i = 0; i < NumBitLevels; ++i) {
            int bit = sym & 1;
            rangeEncoder.encode(Models, startIndex + m, bit);
            m = m << 1 | bit;
            sym >>= 1;
        }
    }
}

