/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import uk.org.retep.util.io.lzma.RangeDecoder;

class BitTreeDecoder {
    private short[] models;
    private int numBitLevels;

    public BitTreeDecoder(int numBitLevels) {
        this.numBitLevels = numBitLevels;
        this.models = new short[1 << numBitLevels];
    }

    public void init() {
        RangeDecoder.initBitModels(this.models);
    }

    public int decode(RangeDecoder rangeDecoder) throws IOException {
        int m = 1;
        for (int bitIndex = this.numBitLevels; bitIndex != 0; --bitIndex) {
            m = (m << 1) + rangeDecoder.decodeBit(this.models, m);
        }
        return m - (1 << this.numBitLevels);
    }

    public int reverseDecode(RangeDecoder rangeDecoder) throws IOException {
        int m = 1;
        int symbol = 0;
        for (int bitIndex = 0; bitIndex < this.numBitLevels; ++bitIndex) {
            int bit = rangeDecoder.decodeBit(this.models, m);
            m <<= 1;
            m += bit;
            symbol |= bit << bitIndex;
        }
        return symbol;
    }

    public static int reverseDecode(short[] Models, int startIndex, RangeDecoder rangeDecoder, int NumBitLevels) throws IOException {
        int m = 1;
        int symbol = 0;
        for (int bitIndex = 0; bitIndex < NumBitLevels; ++bitIndex) {
            int bit = rangeDecoder.decodeBit(Models, startIndex + m);
            m <<= 1;
            m += bit;
            symbol |= bit << bitIndex;
        }
        return symbol;
    }
}

