/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.retep.util.string.StringUtils;

public class JarVersionFileOptimiser {
    private static final Pattern pattern = Pattern.compile("^(.*?)(-([0-9]+)(\\.([0-9]+)(\\.([0-9]+)){0,1}){0,1}){0,1}(-([a-zA-Z0-9]+)){0,1}$");

    private JarVersionFileOptimiser() {
    }

    public static List<OSGIVersion> toOSGIVersion(Collection<File> files) {
        ArrayList<OSGIVersion> list = new ArrayList<OSGIVersion>();
        for (File file : files) {
            list.add(new OSGIVersion(file));
        }
        return list;
    }

    public static Collection<OSGIVersion> getLatest(Collection<OSGIVersion> src) {
        HashMap<String, OSGIVersion> map = new HashMap<String, OSGIVersion>();
        for (OSGIVersion v : src) {
            OSGIVersion b = (OSGIVersion)map.get(v.getSimpleName());
            if (b != null && !v.isNewer(b)) continue;
            map.put(v.getSimpleName(), v);
        }
        return map.values();
    }

    public static List<OSGIVersion> getOutdated(Collection<OSGIVersion> src) {
        ArrayList<OSGIVersion> list = new ArrayList<OSGIVersion>();
        HashMap<String, OSGIVersion> map = new HashMap<String, OSGIVersion>();
        for (OSGIVersion v : src) {
            OSGIVersion b = (OSGIVersion)map.get(v.getSimpleName());
            if (b == null) {
                map.put(v.getSimpleName(), v);
                continue;
            }
            if (v.isNewer(b)) {
                list.add(b);
                map.put(v.getSimpleName(), v);
                continue;
            }
            list.add(v);
        }
        return list;
    }

    public static class OSGIVersion {
        private File file;
        private String name;
        private int major;
        private int minor;
        private int micro;
        private String qualifier;
        private String suffix;
        private String simpleName;

        public String toString() {
            return String.format("%s %d %d %d", this.name, this.major, this.minor, this.micro);
        }

        public OSGIVersion(File file) {
            this.file = file;
            this.suffix = StringUtils.getFileSuffix(file.getName());
            this.name = StringUtils.baseName(file.getName(), this.suffix);
            Matcher m = pattern.matcher(this.name);
            if (!m.matches()) {
                throw new RuntimeException("Cannot decode " + this.name);
            }
            this.name = m.group(1);
            this.major = this.get(m.group(3));
            this.minor = this.get(m.group(5));
            this.micro = this.get(m.group(7));
            this.qualifier = m.group(8);
            this.simpleName = this.name + "." + this.suffix;
        }

        private int get(String s) {
            if (StringUtils.isStringEmpty(s)) {
                return 0;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return 0;
            }
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public File getFile() {
            return this.file;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getMicro() {
            return this.micro;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof OSGIVersion)) {
                return false;
            }
            OSGIVersion b = (OSGIVersion)OSGIVersion.class.cast(arg0);
            return this.name.equals(b.name) && this.suffix.equals(b.suffix);
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.suffix.hashCode();
        }

        public boolean isSameFile(OSGIVersion b) {
            return this.name.equals(b.name) && this.suffix.equals(b.suffix);
        }

        public boolean isNewer(OSGIVersion b) {
            if (b == null) {
                return true;
            }
            if (this.major < b.major) {
                return false;
            }
            if (this.major > b.major) {
                return true;
            }
            if (this.minor < b.minor) {
                return false;
            }
            if (this.minor > b.minor) {
                return true;
            }
            if (this.micro < b.micro) {
                return false;
            }
            if (this.micro > b.micro) {
                return true;
            }
            return this.qualifier != null && (b.qualifier == null || this.qualifier.equals(b.qualifier));
        }
    }
}

