/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import uk.org.retep.swing.model.EnumModel;
import uk.org.retep.util.string.StringUtils;

public enum Hatching implements EnumModel.Renderable
{
    NONE("", false),
    COMPLETED("/", false),
    COMPLETED_FILLED("/F", true),
    COMPLETED_REVERSE("\\\\", false),
    COMPLETED_REVERSE_FILLED("\\\\F", true),
    CROSS("X", false),
    CROSS_HOLLOW("XH", false),
    CROSS_FILLED("XF", true),
    MINUS("-", false),
    MINUS_FILLED("-F", true),
    PLUS("+", false),
    PLUS_FILLED("+F", true),
    SOLID("S", true);

    private String format;
    private boolean filled;

    private Hatching(String format, boolean filled) {
        this.format = format;
        this.filled = filled;
    }

    public String toString() {
        return this.format;
    }

    public static Hatching fromString(String s) {
        if (s != null) {
            for (Hatching h : Hatching.values()) {
                if (!h.toString().equals(s) && !h.name().equalsIgnoreCase(s)) continue;
                return h;
            }
            if ("done".equalsIgnoreCase(s)) {
                return COMPLETED;
            }
        }
        return NONE;
    }

    public void draw(Graphics2D g, Rectangle bounds) {
        GeneralPath p;
        Shape s = p = new GeneralPath();
        Area a = null;
        float x0 = (float)bounds.getX();
        float y0 = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        float x1 = x0 + w;
        float y1 = y0 + h;
        float cx = x0 + w / 2.0f;
        float cy = y0 + h / 2.0f;
        switch (this) {
            default: {
                return;
            }
            case SOLID: {
                s = bounds;
                break;
            }
            case COMPLETED: {
                p.moveTo(x0, y1);
                p.lineTo(x1, y0);
                break;
            }
            case COMPLETED_FILLED: {
                p.moveTo(x0, y1);
                p.lineTo(x0 + 4.0f, y1);
                p.lineTo(x1, y0 + 4.0f);
                p.lineTo(x1, y0);
                p.lineTo(x1 - 4.0f, y0);
                p.lineTo(x0, y1 - 4.0f);
                break;
            }
            case COMPLETED_REVERSE: {
                p.moveTo(x0, y0);
                p.lineTo(x1, y1);
                break;
            }
            case COMPLETED_REVERSE_FILLED: {
                p.moveTo(x0, y0);
                p.lineTo(x0 + 4.0f, y0);
                p.lineTo(x1, y1 - 4.0f);
                p.lineTo(x1, y1);
                p.lineTo(x1 - 4.0f, y1);
                p.lineTo(x0, y0 + 4.0f);
                break;
            }
            case CROSS: {
                p.moveTo(x0, y1);
                p.lineTo(x1, y0);
                p.moveTo(x0, y0);
                p.lineTo(x1, y1);
                break;
            }
            case CROSS_FILLED: 
            case CROSS_HOLLOW: {
                p.moveTo(x0, y1);
                p.lineTo(x0 + 4.0f, y1);
                p.lineTo(x1, y0 + 4.0f);
                p.lineTo(x1, y0);
                p.lineTo(x1 - 4.0f, y0);
                p.lineTo(x0, y1 - 4.0f);
                p.closePath();
                a = new Area(p);
                s = a;
                p.reset();
                p.moveTo(x0, y0);
                p.lineTo(x0 + 4.0f, y0);
                p.lineTo(x1, y1 - 4.0f);
                p.lineTo(x1, y1);
                p.lineTo(x1 - 4.0f, y1);
                p.lineTo(x0, y0 + 4.0f);
                p.closePath();
                a.add(new Area(p));
                break;
            }
            case MINUS: {
                p.moveTo(x0, cy);
                p.lineTo(x1, cy);
                break;
            }
            case MINUS_FILLED: {
                p.moveTo(x0, cy - 2.0f);
                p.lineTo(x1, cy - 2.0f);
                p.lineTo(x1, cy + 2.0f);
                p.lineTo(x0, cy + 2.0f);
                p.closePath();
                break;
            }
            case PLUS: {
                p.moveTo(x0, cy);
                p.lineTo(x1, cy);
                p.moveTo(cx, y0);
                p.lineTo(cx, y1);
                break;
            }
            case PLUS_FILLED: {
                p.moveTo(x0, cy - 2.0f);
                p.lineTo(x1, cy - 2.0f);
                p.lineTo(x1, cy + 2.0f);
                p.lineTo(x0, cy + 2.0f);
                p.closePath();
                a = new Area(p);
                s = a;
                p.reset();
                p.moveTo(cx - 2.0f, y0);
                p.lineTo(cx - 2.0f, y1);
                p.lineTo(cx + 2.0f, y1);
                p.lineTo(cx + 2.0f, y0);
                p.closePath();
                a.add(new Area(p));
            }
        }
        if (this.filled) {
            Color c = g.getColor();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 128));
            g.fill(s);
            g.setColor(c);
        } else {
            g.draw(s);
        }
    }

    @Override
    public String getDescription() {
        return StringUtils.capitaliseEnum(this.name());
    }

    @Override
    public void render(Graphics2D g, int w, int h) {
        this.draw(g, new Rectangle(w, h));
    }
}

