/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class GeomUtils {
    public static final double TwoPI = Math.PI * 2;
    public static final double PIby2 = 1.5707963267948966;
    public static final double PIby4 = 0.7853981633974483;
    private static final int TRACE_DEPTH = 16;

    private GeomUtils() {
    }

    public static Rectangle fitEllipse(Rectangle b) {
        return GeomUtils.fitEllipse(b, false);
    }

    public static Rectangle fitCircle(Rectangle b) {
        return GeomUtils.fitEllipse(b, true);
    }

    private static Rectangle fitEllipse(Rectangle b, boolean circle) {
        double cx = b.getX() + b.getWidth() / 2.0;
        double cy = b.getY() + b.getHeight() / 2.0;
        double r1 = Math.abs((b.getX() - cx) / Math.sin(0.7853981633974483));
        double r2 = Math.abs((b.getY() - cy) / Math.cos(0.7853981633974483));
        if (circle) {
            r1 = r2 = Math.max(r1, r2);
        }
        return GeomUtils.createRectangle(cx - r1, cy - r1, 2.0 * r1, 2.0 * r2);
    }

    public static Ellipse2D createEllipse2D(Rectangle bounds) {
        Ellipse2D.Double e = new Ellipse2D.Double();
        e.setFrame(bounds);
        return e;
    }

    public static Rectangle createRectangle(double x, double y, double w, double h) {
        Rectangle ret = new Rectangle();
        ret.setRect(x, y, w, h);
        return ret;
    }

    public static Point2D getCentre(Shape shape) {
        return GeomUtils.getCentre(shape.getBounds());
    }

    public static Point2D getCentre(Rectangle2D rectangle) {
        return new Point2D.Double(rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY() + rectangle.getHeight() / 2.0);
    }

    public static Point2D getCentre(Line2D line) {
        return new Point2D.Double((line.getX1() + line.getX2()) / 2.0, (line.getY1() + line.getY2()) / 2.0);
    }

    public static Point2D findIntersection(Line2D a, Line2D b) {
        double num = (a.getY2() - a.getY1()) * (a.getX1() - b.getX1()) - (a.getX2() - a.getX1()) * (a.getY1() - b.getY1());
        double denom = (a.getY2() - a.getY1()) * (b.getX2() - b.getX1()) - (a.getX2() - a.getX1()) * (b.getY2() - b.getY1());
        double f = num / denom;
        return new Point2D.Double(b.getX1() + (b.getX2() - b.getX1()) * f, b.getY1() + (b.getY2() - b.getY1()) * f);
    }

    public static Point2D findIntersection(Line2D line, Shape shape) {
        boolean containsFirst = shape.contains(line.getP1());
        if (containsFirst == shape.contains(line.getP2())) {
            return null;
        }
        Line2D l = (Line2D)line.clone();
        for (int i = 0; i < 16; ++i) {
            Point2D middle = GeomUtils.getCentre(l);
            l = containsFirst != shape.contains(middle) ? new Line2D.Double(l.getP1(), middle) : new Line2D.Double(middle, l.getP2());
        }
        return GeomUtils.getCentre(l);
    }

    public static void setDashStroke(Graphics2D g, float ... dash) {
        int cap = 1;
        int join = 1;
        float mitre = 1.0f;
        float width = 0.0f;
        try {
            BasicStroke s = (BasicStroke)g.getStroke();
            cap = s.getEndCap();
            join = s.getLineJoin();
            mitre = s.getMiterLimit();
            width = s.getLineWidth();
        }
        catch (Exception e) {
            // empty catch block
        }
        g.setStroke(new BasicStroke(width, cap, join, mitre, dash, 0.0f));
    }

    public static float getStrokeWidth(Graphics2D g) {
        Stroke s = g.getStroke();
        if (s instanceof BasicStroke) {
            return ((BasicStroke)s).getLineWidth();
        }
        return 0.0f;
    }
}

